% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrypt.R
\name{decrypt}
\alias{decrypt}
\title{Decrypt a dataframe or tibble column using an RSA public/private key}
\usage{
decrypt(.data, ..., private_key_path = "id_rsa", lookup_object = NULL,
  lookup_path = NULL)
}
\arguments{
\item{.data}{A dataframe or tibble.}

\item{...}{The unquoted names of columns to decrypt.}

\item{private_key_path}{Character. A quoted path to an RSA private key
created using \code{\link{genkeys}}.}

\item{lookup_object}{An unquote name of a lookup object in the current
environment created using \code{link{encrypt}}.}

\item{lookup_path}{Character. A quoted path to an RSA private key
created using \code{\link{encrypt}}.}
}
\value{
The original dataframe or tibble with the specified columns
  decrypted.
}
\description{
Decrypt a dataframe or tibble column using an RSA public/private key
}
\examples{
\dontrun{
library(dplyr)
gp_encrypt = gp \%>\%
  select(-c(name, address1, address2, address3)) \%>\%
  encrypt(postcode, telephone)

gp_encrypt \%>\%
  decrypt(postcode, telephone)
}
}
