% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bark.R
\name{bark}
\alias{bark}
\alias{bark.trackdata}
\alias{bark.spectral}
\alias{bark.default}
\title{Convert Hertz to Bark and Bark to Hertz}
\usage{
bark(f, inv = FALSE, ...)
}
\arguments{
\item{f}{A vector or matrix of data or a spectral object.}

\item{inv}{A single element logical vector. If FALSE, data are converted from
Hertz to Bark, if TRUE, data are converted from Bark to Hertz. (Does not apply
if 'data' is an oject of class 'spectral'.}

\item{\dots}{for generic only}
}
\value{
A vector or matrix or spectral object of the same length and dimensions as
data.
}
\description{
The calculation is done using the formulae Traunmueller (1990)
}
\details{
If 'data' is a spectral object, then

the frequencies are changed so that they are proportional

to the Bark scale and such that the Bark intervals

between frequencies are con stant between the lowest

and highest frequencies. More specifically,

suppose that a spectral object has frequencies

at 0, 1000, 2000, 3000, 4000 Hz. Then the corresponding

frequencies extend in Bark between 0 and 17.46329 Bark

in four equal intervals, and linear interpolation

is used with the 'approx' function to obtain

the dB values at those frequencies. Negative frequencies

which are obtained for values of about less than 40 Hz

are removed in the case of spectral objects.
}
\examples{




   # convert Hertz values to Bark

        vec <- c(500, 1500, 2500)

        vec

        bark(vec)



        

        # convert Hertz values to Bark and back to Hertz

        bark(bark(vec, inv=TRUE))

        



        # convert the $data values in a trackdata object to Bark

        # create a new track data object

        t1 <- dip.fdat

        t1[1]

        



        # convert Hertz to Bark

        t1$data <- bark(t1$data)

        t1[1]



# warp the frequency axis of a spectral object such

# that it is proportional to the Bark scale.

w = bark(e.dft)

oldpar = par(mfrow=c(1,2))

plot(w, type="l")



# The values of w are at equal Bark intervals. Compare

# with

plot(e.dft, freq=bark(trackfreq(e.dft)))

# the latter has a greater concentration of values

# in a higher frequency range.

par(oldpar)


}
\references{
Traunmueller, H. (1990) "Analytical expressions for the
tonotopic sensory scale" J. Acoust. Soc. Am. 88: 97-100.
}
\seealso{
\code{\link{mel}},

\code{\link{plot.spectral}}
}
\author{
Jonathan Harrington
}
\keyword{math}
