\name{dominated_hypervolume}
\alias{dominated_hypervolume}
\title{Dominated Hypervolume calculation...}
\usage{dominated_hypervolume(points, ref)
hypervolume_contribution(points, ref)
}
\description{Dominated Hypervolume calculation}
\details{\code{dominated_hypervolume}: \code{dominated_hypervolume} calculates the dominated hypervolume of
the points in \code{points}. 

\code{hypervolume_contribution} calculates the hypervolume
contribution of each point.

If no reference point \code{ref} is given, one is automatically
calculated by determening the maximum in each coordinate.

Currently only one general algorithm is implemented due to Fonseca
et.al. but work is underway to include others such as the Beume &
Rudolph approach as well as the approach by Bradstreet et.al.

The 1D and 2D cases are handle seperately by efficient algorithms.
Calculates the exact dominated hypervolume of the points given in
\code{x} subject to the reference point \code{ref}.

}
\value{\code{dominated_hypervolume}: For \code{dominated_hypervolume} the dominated hypervolume
by the points in \code{points} with respect to the reference point
\code{ref}. For \code{hypervolume_contribution} a vector giving
the hypervolume soley dominated by that point.

}
\seealso{\code{\link{nondominated_points}} to extract the pareto
front approximation from a given set of points and
\code{\link{nds_hv_selection}} for a selection strategy based on
the hypervolume contribution of each point.}
\references{This code uses the Fonseca et.al. code from
\url{http://iridia.ulb.ac.be/~manuel/hypervolume}. For a
description of the used algorithm see

Carlos M. Fonseca, Luis Paquete, and Manuel Lopez-Ibanez. \emph{An
improved dimension-sweep algorithm for the hypervolume
indicator}. In IEEE Congress on Evolutionary Computation, pages
1157-1163, Vancouver, Canada, July 2006.}
\author{Olaf Mersmann \email{olafm@statistik.tu-dortmund.de}}
\keyword{optimize}
\arguments{\item{points}{Matrix containing the points one per column.}
\item{ref}{Optional reference point. If not provided the maximum
in each dimension is used.}
}
\alias{hypervolume_contribution}

