% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cforest.r
\name{fit_cforest}
\alias{fit_cforest}
\title{Fit conditional inference forest}
\usage{
fit_cforest(x, y, formula = y ~ ., ctrl_fun = party::cforest_unbiased, ...)
}
\arguments{
\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Responses.}

\item{formula}{Formula linking response to descriptors.}

\item{ctrl_fun}{Which control function to use, see \code{\link[party]{cforest_control}}.}

\item{...}{Sent to the function specified by \code{ctrl_fun}.}
}
\value{
A fitted \code{\link[party]{cforest}} model.
}
\description{
A \code{\link[party]{cforest}} is a random forest based on conditional inference
trees, using the implementation in the \pkg{party} package.
These trees can be used for classification, regression or survival
analysis, but only the survival part has been properly tested so far.
}
\details{
The parameters to \code{\link[party]{cforest}} are set using a
\code{\link[party]{cforest_control}} object. You should read the documentation
as the default values are chosen for technical reasons, not predictive
performance!
Pay special attention to \code{mtry} which is set very low by default.
}
\references{
Torsten Hothorn, Peter Buehlmann, Sandrine Dudoit, Annette Molinaro
  and Mark Van Der Laan (2006). Survival Ensembles. Biostatistics,
  7(3), 355--373.

  Carolin Strobl, Anne-Laure Boulesteix, Achim Zeileis and Torsten
  Hothorn (2007). Bias in Random Forest Variable Importance Measures:
  Illustrations, Sources and a Solution. BMC Bioinformatics, 8(25). URL
  http://www.biomedcentral.com/1471-2105/8/25.

  Carolin Strobl, Anne-Laure Boulesteix, Thomas Kneib, Thomas Augustin
  and Achim Zeileis (2008). Conditional Variable Importance for Random
  Forests. BMC Bioinformatics, 9(307). URL
  http://www.biomedcentral.com/1471-2105/9/307.
}
\seealso{
\code{\link{emil}}, \code{\link{predict_cforest}},
  \code{\link{modeling_procedure}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
