% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSP.list.R
\docType{data}
\name{TSP.list}
\alias{TSP.list}
\title{Database of thermosensitive period of development for sex determination}
\format{A list with dataframes including attributes}
\usage{
TSP.list
}
\description{
Database of thermosensitive period of development for sex determination.\cr
This database can be used with the functions plot() or info.nests().\cr
The attributes TSP.begin.stages and TSP.end.stages for each dataframe give 
respectively the first and the last stages for TSP. Then the metrics for the limits of TSP 
are:\cr
TSP.list[[1]]$metric[TSP.list[[1]]$stages==attributes(TSP.list[[1]])$TSP.begin.stages] and \cr
TSP.list[[1]]$metric[TSP.list[[1]]$stages==1+attributes(TSP.list[[1]])$TSP.end.stages]
}
\details{
Database of thermosensitive period of development for sex determination
}
\examples{
\dontrun{
library(embryogrowth)
data(TSP.list)
names(TSP.list)
TSP.list[["Emys_orbicularis.mass"]]
attributes(TSP.list[["Emys_orbicularis.mass"]])$TSP.begin.stages
attributes(TSP.list[["Emys_orbicularis.mass"]])$TSP.end.stages
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Mrosovsky, N., Pieau, C., 1991. Transitional range of temperature, pivotal 
temperatures and thermosensitive stages for sex determination in reptiles. 
Amphibia-Reptilia 12, 169-179.
}
\seealso{
Other Functions.for.temperature.dependent.sex.determination: \code{\link{DatabaseTSD}},
  \code{\link{predict.tsd}}, \code{\link{stages}},
  \code{\link{tsd_MHmcmc_p}}, \code{\link{tsd_MHmcmc}},
  \code{\link{tsd}}
}
\keyword{datasets}

