% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{server}
\alias{server}
\alias{gmail}
\alias{sendgrid}
\alias{mailgun}
\alias{sendinblue}
\alias{mailersend}
\alias{smtpbucket}
\title{Create a SMTP server object.}
\usage{
server(
  host,
  port = 25,
  username = NULL,
  password = NULL,
  insecure = FALSE,
  reuse = TRUE,
  helo = NA,
  protocol = NA,
  test = FALSE,
  pause_base = 1,
  max_times = 5,
  ...
)

gmail(username, password, ...)

sendgrid(password, ...)

mailgun(username, password, ...)

sendinblue(username, password, ...)

mailersend(username, password, ...)

smtpbucket(...)
}
\arguments{
\item{host}{DNS name or IP address of the SMTP server.}

\item{port}{Port that the SMTP server is listening on.}

\item{username}{Username for SMTP server.}

\item{password}{Password for SMTP server or API key.}

\item{insecure}{Whether to ignore SSL issues.}

\item{reuse}{Whether the connection to the SMTP server should be left open for reuse.}

\item{helo}{The HELO domain name of the sending host. If left as \code{NA} then will use local host name.}

\item{protocol}{Which protocol (SMTP or SMTPS) to use for communicating with
the server. Default will choose appropriate protocol based on port.}

\item{test}{Test login to server.}

\item{pause_base}{Base delay (in seconds) for exponential backoff. See \link[purrr]{rate_backoff}.}

\item{max_times}{Maximum number of times to retry.}

\item{...}{Additional curl options. See \code{curl::curl_options()} for a list of supported options.}
}
\value{
A function which is used to send messages to the server.
}
\description{
Create an object which can be used to send messages to an SMTP server.
}
\details{
These functions return a function which can then be called with a message object.
}
\section{Gmail}{


If you're having trouble authenticating with Gmail then you should try the following:
\itemize{
\item enable 2-factor authentication and
\item create an app password.
}

Then use the app password rather than your usual account password.
}

\section{Sendgrid}{


To use SendGrid you'll need to first \href{https://docs.sendgrid.com/for-developers/sending-email/integrating-with-the-smtp-api}{create an API key}.
Then use the API key as the password.

SendGrid will accept messages on ports 25, 587 and 2525 (using SMTP) as well
as 465 (using SMTPS).
}

\section{Mailgun}{


To use Mailgun you'll need to first register a sender domain. This will then
be assigned a username and password.

Mailgun will accept messages on ports 25 and 587 (using SMTP) as well as 465
(using SMTPS).
}

\section{Sendinblue}{


To use Sendinblue you'll need to first create an account. You'll find your
SMTP username and password in the SMTP & API section of your account
settings.
}

\section{MailerSend}{


To use MailerSend you'll need to first create an account. You'll find your
SMTP username and password under Domains. See \href{https://www.mailersend.com/help/smtp-relay}{How to send emails via SMTP with MailerSend}.

Although this is not likely to be a problem in practice, MailerSend insists
that all messages have at minimum a valid subject and either text or HTML
content.
}

\section{SMTP Bucket}{


SMTP Bucket is a fake SMTP server that captures all the messages it receives
and makes them available through a website or REST API.
}

\examples{
# Set parameters for SMTP server (with username and password).
smtp <- server(
  host = "smtp.gmail.com",
  port = 587,
  username = "bob@gmail.com",
  password = "bd40ef6d4a9413de9c1318a65cbae5d7"
)

# Set parameters for a (fake) testing SMTP server.
#
# More information about this service can be found at https://www.smtpbucket.com/.
#
smtp <- server(
  host = "mail.smtpbucket.com",
  port = 8025
)

# Create a message
msg <- envelope() \%>\%
  from("bob@gmail.com") \%>\%
  to("alice@yahoo.com")

# Send message (verbose output from interactions with server)
\dontrun{
smtp(msg, verbose = TRUE)
}

# To confirm that the message was sent, go to https://www.smtpbucket.com/ then:
#
# - fill in "bob@gmail.com" for the Sender field and
# - fill in "alice@yahoo.com" for the Recipient field then
# - press the Search button.

# With explicit HELO domain.
#
smtp <- server(host = "mail.example.com",
               helo = "client.example.com")

# Set parameters for Gmail SMTP server. The host and port are implicit.
smtp <- gmail(
  username = "bob@gmail.com",
  password = "bd40ef6d4a9413de9c1318a65cbae5d7"
)

# Set API key for SendGrid SMTP server.
smtp <- sendgrid(
  password = "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"
)

# Set username and password for Mailgun SMTP server.
smtp <- mailgun(
  username = "postmaster@sandbox9ptce35fdf0b31338dec4284eb7aaa59.mailgun.org",
  password = "44d072e7g2b5f3bf23b2b642da0fe3a7-2ac825a1-a5be680a"
)

# Set username and password for Sendinblue SMTP server.
smtp <- sendinblue(
  username = "bob@gmail.com",
  password = "xsmtpsib-c75cf91323adc53a1747c005447cbc9a893c35888635bb7bef1a624bf773da33"
)

# Set username and password for MailerSend SMTP server.
smtp <- mailersend(
  username = "NS_Pf3ALM@gmail.com",
  password = "e5ATWLlTnWWDaKeE"
)

# SMTP Bucket server.
smtp <- smtpbucket()
}
