% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-openai.R
\name{chat_openai}
\alias{chat_openai}
\title{Chat with an OpenAI model}
\usage{
chat_openai(
  system_prompt = NULL,
  turns = NULL,
  base_url = "https://api.openai.com/v1",
  api_key = openai_key(),
  model = NULL,
  seed = NULL,
  api_args = list(),
  echo = c("none", "text", "all")
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{OPENAI_API_KEY} environment
variable.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://openai.com/}{OpenAI} provides a number of chat-based models,
mostly under the \href{https://chat.openai.com/}{ChatGPT} brand.
Note that a ChatGPT Plus membership does not grant access to the API.
You will need to sign up for a developer account (and pay for it) at the
\href{https://platform.openai.com}{developer platform}.

For authentication, we recommend saving your
\href{https://platform.openai.com/account/api-keys}{API key} to
the \code{OPENAI_API_KEY} environment variable in your \code{.Renviron} file.
You can easily edit this file by calling \code{usethis::edit_r_environ()}.
}
\examples{
\dontshow{if (has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_openai()
chat$chat("
  What is the difference between a tibble and a data frame?
  Answer with a bulleted list
")

chat$chat("Tell me three funny jokes about statistcians")
\dontshow{\}) # examplesIf}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_cortex}()},
\code{\link{chat_databricks}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
