% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seats.R
\name{seats}
\alias{seats}
\title{Download data on the number of seats under dispute in federal elections}
\usage{
seats(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year. For this function, only the years of 1998, 2002, 2006, 2010, 2014 and 2018
are available.}

\item{uf}{Federation Unit acronym (\code{character} vector).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recoverns only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE} keep temporary compressed file}

\item{readme_pdf}{original readme}
}
\value{
\code{seats()} returns a \code{data.frame}.
}
\description{
\code{seats()} downloads and aggregates data on the number of seats under dispute in
federal elections in Brazil. The function returns a \code{tbl, data.frame} where each observation
corresponds to a district-office dyad.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- seats(2000)
}
}
