% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/details_mun_zone_fed.R
\name{details_mun_zone_fed}
\alias{details_mun_zone_fed}
\title{Download data on the verification of federal elections in Brazil}
\usage{
details_mun_zone_fed(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 1994, 1998, 2002, 2006, 2010, 2014 and 2018
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recoverns only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). elections_rda}
}
\value{
\code{details_mun_zone_fed()} returns a \code{data.frame} with the following variables:
}
\description{
\code{details_mun_zone_fed()} downloads and aggregates data on the verification of federal elections in Brazil,
disaggregated by town and electoral zone. The function returns a \code{data.frame} where each observation
corresponds to a town/zone.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2002, some information can be incomplete. For the 2014 and 2018 elections, more variables are available.
}
\examples{
\dontrun{
df <- details_mun_zone_fed(2002)
}
}
