# egcm_data.R
# Copyright (C) 2014 by Matthew Clegg

# Data sets used for calibrating the Engle Granger cointegration tests

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/

# The following table was generated using the call
#   egc_adf_qtab <- egc_quantile_table("adf")
egc_adf_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-5.80600065964837, -3.96967149868031, -3.57824796147135, -3.25972771321035, 
-2.91769544207541, -2.53653941727733, -1.87885900097153, -1.23635907388638, 
-0.848888902162473, -0.497965156016583, -0.226150888703246, 0.0919944227492717, 
0.715514345109964, 1.13746830802583), `50` = c(50, -5.24240810499968, 
-3.88436984764926, -3.51841394814949, -3.22772975052556, -2.93249574413191, 
-2.57511899641644, -1.93534867641615, -1.29792146450943, -0.897388203762267, 
-0.546047631311591, -0.247930007718635, 0.0923702276922401, 0.789911712445357, 
1.1349646405655), `100` = c(100, -5.18614553477463, -3.82028178996715, 
-3.50744267955286, -3.24705549993499, -2.94175070261879, -2.59348547506723, 
-1.95834721747418, -1.32553379739761, -0.93443865659125, -0.566504307577409, 
-0.242061094013615, 0.111373176009, 0.867741882893275, 1.59691079410486
), `250` = c(250, -5.05252931421373, -3.84060323769614, -3.52272563987771, 
-3.27285179097311, -2.98843125307626, -2.63978528664028, -1.99656573545568, 
-1.34914752339741, -0.955671079430595, -0.59536217425783, -0.252621338347237, 
0.0899987781539045, 0.969480195222591, 1.67437762726293), `500` = c(500, 
-4.85128032044083, -3.85833025117506, -3.55728995027321, -3.30071683971755, 
-3.01071194742856, -2.6609928745281, -2.02202638716769, -1.37661045477456, 
-0.98234250690942, -0.619068716843792, -0.27371347078372, 0.13315155687368, 
0.865369556696318, 1.52205842706039), `750` = c(750, -4.83835340698721, 
-3.83881344355717, -3.54242745598571, -3.29704259642577, -3.01323322264831, 
-2.66483797384133, -2.02994011861584, -1.37999100147531, -0.999328031721282, 
-0.621031412365913, -0.292480170395573, 0.0800960217442984, 0.897234407421888, 
1.50745527599032), `1000` = c(1000, -4.97941096009447, -3.85485811203703, 
-3.5541966311385, -3.30433478199755, -3.01909801272636, -2.6777972051341, 
-2.03200019463226, -1.38431436486989, -0.996001675456806, -0.634806184644324, 
-0.300563520344664, 0.0969685582020578, 0.970683881879207, 1.48835101741877
), `1250` = c(1250, -5.0796703725486, -3.87636404563864, -3.5691833688799, 
-3.31236204044198, -3.01659802560495, -2.67464862923784, -2.0338504140494, 
-1.38393075567463, -0.992858354334467, -0.612689283453555, -0.277705535093365, 
0.12234390933653, 0.835475797246308, 1.51161252736622), `2500` = c(2500, 
-4.93123154657244, -3.87361135465214, -3.57724739925402, -3.31986317733849, 
-3.0239955384488, -2.68391352548266, -2.04130703323206, -1.38983251418602, 
-1.00504861561616, -0.628990737143362, -0.303520699416405, 0.104495525816474, 
0.929299065343716, 1.59447329546194)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#  egc_pp_qtab <- egc_quantile_table("pp")
egc_pp_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-29.7565417246292, -20.3971994666692, -18.146559481418, -16.3011085149503, 
-14.2391155820147, -11.8150963786742, -7.5899592780893, -4.15096635903013, 
-2.60094473871757, -1.43339001874047, -0.467039141445771, 0.570199459331984, 
2.57940275214657, 4.84025830039889), `50` = c(50, -37.2231274542497, 
-24.4557731741679, -21.3929138388286, -18.8614871870361, -16.1389752507269, 
-13.0795192863213, -8.04644566917229, -4.29658782369691, -2.68013964887425, 
-1.48502292300255, -0.584507066376888, 0.37615470388534, 2.40978417480265, 
4.3200178128311), `100` = c(100, -43.426742478486, -27.5974048358845, 
-23.6031859946393, -20.4580160947768, -17.1986747077983, -13.6429760820469, 
-8.12217622614848, -4.22777954156694, -2.66476562368888, -1.54545744092887, 
-0.636175690120419, 0.261961612457279, 2.12993106273921, 3.56562198394928
), `250` = c(250, -47.0690681964392, -29.0960896400917, -24.4928331552785, 
-21.1394469521393, -17.5358643357831, -13.7600996041061, -8.14408729814865, 
-4.25496422851803, -2.68238752031604, -1.49700685184211, -0.618656815748225, 
0.289530850749153, 1.96587622968128, 3.16868565102177), `500` = c(500, 
-51.205031814866, -28.6470594302683, -24.4050407990774, -21.002428033627, 
-17.4392919303947, -13.6870811851613, -8.05915371009938, -4.1573647915354, 
-2.59945753801057, -1.49248336310081, -0.686908685958931, 0.158466529052688, 
1.91231921279196, 3.44605376774065), `750` = c(750, -50.5572979664773, 
-29.0262823972601, -24.6390828311317, -21.0567367643718, -17.4234244154485, 
-13.559135320141, -8.00806944056452, -4.14335083605078, -2.62965842402231, 
-1.52762518846525, -0.692309593470999, 0.164594069455772, 1.84175773730567, 
3.26339389208958), `1000` = c(1000, -51.0721393168863, -28.9701152727192, 
-24.499116452129, -20.9693265964951, -17.3041276025917, -13.5313579759124, 
-7.98874954375296, -4.16108848474232, -2.63667336022509, -1.57321498718066, 
-0.727235377853383, 0.149961637320794, 1.82950678217979, 3.58839310935961
), `1250` = c(1250, -47.0274336884959, -28.6533901782375, -24.0324308135337, 
-20.7516904573044, -17.2676130652863, -13.5632485477366, -8.02973231588857, 
-4.16297729023449, -2.65204125672226, -1.54778453385605, -0.656865646170381, 
0.224883510382165, 1.98145276951501, 3.13000464851758), `2500` = c(2500, 
-47.7056243655114, -28.2578110834848, -23.9980052350113, -20.6534631941346, 
-17.2047997356392, -13.5207335338673, -7.957478348813, -4.14981750150314, 
-2.58643765337459, -1.5149841942779, -0.661445201665475, 0.207478441219318, 
1.73413672925087, 2.96418512944668)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#  egc_pgff_qtab <- egc_quantile_table("pgff")
egc_pgff_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-0.231553821881206, 0.142707930240386, 0.248133260656542, 0.333917931689774, 
0.428121640033571, 0.539945782620781, 0.723771557722711, 0.864332597229699, 
0.922105249101673, 0.963987601206701, 0.996514536929339, 1.02970707350455, 
1.10265843354382, 1.1684196848773), `50` = c(50, 0.172811744068844, 
0.523681965900934, 0.586787791731764, 0.640475243182477, 0.698272283692989, 
0.763003427158865, 0.861510838608303, 0.934865539270229, 0.963988752897878, 
0.983684298255712, 0.999107902125492, 1.01523872341966, 1.04887589032764, 
1.08320927058697), `100` = c(100, 0.58393295331061, 0.747302308926479, 
0.786594503536844, 0.814706946790915, 0.844627757777947, 0.878151159116796, 
0.930456653782436, 0.967744096406227, 0.982277425352853, 0.992439536130561, 
0.999948043879276, 1.00854567758384, 1.02455735085789, 1.03589000947898
), `250` = c(250, 0.820931819498695, 0.893121918045134, 0.9100444253408, 
0.922701510027215, 0.936176560408352, 0.950630316233532, 0.971938078796866, 
0.987249212798609, 0.993316215891717, 0.997302849731884, 1.00026049554445, 
1.00339170281377, 1.00986200038529, 1.01497502980754), `500` = c(500, 
0.915260264269203, 0.947660316795335, 0.955120881224063, 0.9615512652387, 
0.968212673123382, 0.975333878457326, 0.986218358977486, 0.993749755656947, 
0.996700016813508, 0.998651986392834, 1.00022742264255, 1.00174462894202, 
1.00503195091248, 1.00869804701151), `750` = c(750, 0.939511376775531, 
0.964242019206539, 0.969609009891871, 0.974159154779863, 0.978638973401466, 
0.983479379364544, 0.99068408949163, 0.995796764989488, 0.997756641711029, 
0.999151670945693, 1.00012854429786, 1.00115905482996, 1.00333079120998, 
1.00461694750751), `1000` = c(1000, 0.952901846335396, 0.972960770846218, 
0.977387781442881, 0.980456839686105, 0.983879665729278, 0.987602057811466, 
0.9930813790635, 0.996847012417422, 0.998291609862028, 0.999314605853998, 
1.00007633788893, 1.00083212864199, 1.00248963474574, 1.0036755295172
), `1250` = c(1250, 0.963783393138941, 0.978506759104274, 0.981788753156713, 
0.984371043883735, 0.9872049444274, 0.990088040796763, 0.994415785666173, 
0.997452177824305, 0.998650014908854, 0.999454178064819, 1.00007265964321, 
1.00070857738882, 1.00193592290277, 1.00293182022315), `2500` = c(2500, 
0.982585320556602, 0.989012853244208, 0.990724098334862, 0.992056016938316, 
0.993504460846469, 0.995006847754035, 0.997207718401152, 0.998716056355613, 
0.999321415287837, 0.999730791683232, 1.00004377282568, 1.00037315158441, 
1.00102596100525, 1.00166334013542)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")
  
# The following table was generated using the call
#  egc_joe_qtab <- egc_quantile_table("jo-e")
egc_joe_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-37.4934491481087, -23.4752500251861, -20.7322351509806, -18.4802462385388, 
-16.0904351483193, -13.5967528699361, -9.72782001868844, -6.85330218916773, 
-5.67715127234161, -4.86414622392108, -4.2424163183183, -3.59728147515604, 
-2.6331400775029, -1.93339435261407), `50` = c(50, -34.4383406226246, 
-21.5843795460596, -18.9497918614636, -16.9014607734677, -14.7380598332874, 
-12.4963014673808, -8.93765721819998, -6.30730843381653, -5.23804065964026, 
-4.45726352911189, -3.89418248928871, -3.30788625722547, -2.3253363699569, 
-1.83973277304182), `100` = c(100, -31.4969937222486, -20.6542048961051, 
-18.2994013572307, -16.3016078616509, -14.3018906386804, -12.1089714262841, 
-8.69332514602511, -6.11081103857875, -5.00977087514907, -4.27494697678329, 
-3.69821816214648, -3.14606616699598, -2.29523504952876, -1.88177947492758
), `250` = c(250, -29.9886203544917, -20.3134182049498, -17.7958631304333, 
-15.9003842383322, -13.9392094994162, -11.8506643765848, -8.49972915146836, 
-5.99143403235332, -4.94647714760393, -4.2292217784859, -3.67847415991356, 
-3.12273027260759, -2.18613631874027, -1.65620389938301), `500` = c(500, 
-31.0799734994848, -20.3476972506917, -17.8641226163083, -15.984269524298, 
-13.9885808720719, -11.8609093357509, -8.47264259127889, -5.96103482546849, 
-4.91823850171487, -4.18169641700738, -3.63141265114147, -3.06808234648939, 
-2.21626106403673, -1.64730084697278), `750` = c(750, -29.7711360611772, 
-20.2485974761581, -17.9400968340255, -16.0018615584896, -14.0424937323286, 
-11.8515113665148, -8.44217565186761, -5.92367629729155, -4.89155291683393, 
-4.14127061751557, -3.57756688544588, -3.0410906729227, -2.10959025824598, 
-1.72552476877069), `1000` = c(1000, -29.8691782696184, -20.23651212437, 
-17.9051159103113, -16.0115740479624, -13.9679312360707, -11.7487752998559, 
-8.42039292462495, -5.88719641677412, -4.85645488013636, -4.13790343739176, 
-3.59785138916529, -3.0380644069827, -2.17965907294437, -1.64956499964293
), `1250` = c(1250, -32.4070442032071, -20.3053859149176, -17.8479733284502, 
-16.0097134307693, -14.0199581926918, -11.8345750857438, -8.46600371563483, 
-5.90968973735435, -4.88283780987849, -4.15764219129007, -3.59892608622552, 
-3.07077442036504, -2.21070605459954, -1.54299694506694), `2500` = c(2500, 
-30.3095709948853, -20.245554884956, -17.8867818774405, -16.0047058240053, 
-13.9945246714598, -11.7875259069063, -8.43968864047374, -5.92373337410219, 
-4.87901776894278, -4.16056440196444, -3.62883846279096, -3.07973101793951, 
-2.10998984940825, -1.43505686885504)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#  egc_jot_qtab <- egc_quantile_table("jo-t")
egc_jot_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-43.6039139855407, -28.6829709794164, -25.6300537603927, -23.3079359185719, 
-20.643739189464, -17.7884740594005, -13.1348239053396, -9.58693660153554, 
-8.05909112818845, -7.01406411497141, -6.19569951461884, -5.35591475011705, 
-4.08260696696836, -3.31049871144232), `50` = c(50, -38.4752049971958, 
-26.8080988779882, -23.9437700481207, -21.5574845593767, -19.0774684501909, 
-16.5045018454215, -12.183631307656, -8.84373681572512, -7.46100621867351, 
-6.47530477837974, -5.69218935468569, -4.89007873490613, -3.66579155674075, 
-2.7324831220996), `100` = c(100, -40.2124175203202, -25.5893372632967, 
-23.0323211816574, -20.810618288626, -18.5040229104433, -15.9183860115843, 
-11.74611718597, -8.55756459180621, -7.1880271146337, -6.1612913901399, 
-5.4259638635224, -4.66717848573724, -3.64213982185279, -2.82147037506989
), `250` = c(250, -36.8363870121499, -25.503723090232, -22.7913067921628, 
-20.5647324983675, -18.3227705275422, -15.7148313468566, -11.5691663072761, 
-8.37606828061385, -7.01749168898447, -6.07378903078064, -5.33387231670868, 
-4.55762374951882, -3.37367431197166, -2.71177217407318), `500` = c(500, 
-35.8931079990305, -25.5067935105137, -22.6971799724303, -20.4943323346414, 
-18.0772809282935, -15.5533042944476, -11.4923511862326, -8.32760076448148, 
-7.00568646305856, -6.07714694733917, -5.32811847017675, -4.58102351459653, 
-3.25159378652592, -2.65054723217171), `750` = c(750, -37.745032170643, 
-25.0822599618117, -22.4732901668475, -20.3703679268076, -18.0870793164142, 
-15.5682318967508, -11.4780249865322, -8.33286518403125, -7.00996697530282, 
-6.04396418081035, -5.30102486235099, -4.57043493336911, -3.35455895999861, 
-2.73356562079151), `1000` = c(1000, -36.2344573655043, -25.1038801150724, 
-22.3998867232976, -20.206581784596, -17.9432295463599, -15.4644455837395, 
-11.4531807056099, -8.33200153188878, -6.98751115066501, -5.99846251864034, 
-5.30359410405053, -4.55912626375865, -3.33973427265424, -2.69388481757016
), `1250` = c(1250, -36.422058957083, -25.1248808353849, -22.4460546913756, 
-20.3446739203963, -18.0567540031894, -15.5546815514663, -11.4659570172447, 
-8.29301400579434, -6.94723871532745, -5.97833367858986, -5.20389564066867, 
-4.44983350810362, -3.32349110694732, -2.64683960242408), `2500` = c(2500, 
-35.6379697758194, -25.2733069974919, -22.5247104652215, -20.2349350303678, 
-18.018940187706, -15.4994530355328, -11.4738335040917, -8.29267196408465, 
-6.97256431918771, -6.01373746763148, -5.29545588131238, -4.58138773087048, 
-3.30109427170537, -2.42493858524213)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#  egc_ersp_qtab <- egc_quantile_table("ers-p")
egc_ersp_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
1.62524409776054e-07, 0.000993351217457755, 0.00632761422919328, 
0.0249541713400963, 0.100253417145221, 0.418009322648233, 2.74077437917608, 
11.8806257428513, 26.4527501186186, 50.121416245285, 87.4788254786966, 
154.044526454243, 482.515677121453, 1057.59828306248), `50` = c(50, 
4.41794940706963e-06, 0.0336334027403853, 0.158165985952471, 
0.452392884816047, 0.97261682326569, 1.85027936383228, 4.72929871946086, 
12.6897052690977, 22.5058316159347, 35.929045705844, 53.7546692149607, 
85.7649714447181, 206.542652092838, 345.09085580573), `100` = c(100, 
0.0619721273346449, 0.773203593988022, 1.1139559460748, 1.48875625449004, 
2.0335260175412, 2.96866136348471, 6.4919829149133, 15.8510632535666, 
26.1910387762326, 38.9669225289442, 56.0924147744943, 83.9700427535428, 
162.266700361115, 281.921761751524), `250` = c(250, 0.55528634965954, 
1.23137663481992, 1.57480118078469, 1.94753752564035, 2.51853403907714, 
3.61084771611864, 7.89655166213118, 19.383586807307, 31.2095674719374, 
45.6997855930344, 62.1238728131958, 88.3597119501477, 166.937708487234, 
263.921546782893), `500` = c(500, 0.639334997026308, 1.30343258621287, 
1.62016826096752, 2.01087268057896, 2.61945158602907, 3.75029646128193, 
8.23426950014149, 20.4772688421125, 32.9302712128018, 47.7929142735086, 
65.0872316662308, 89.3623155688477, 167.423512438777, 239.86696480845
), `750` = c(750, 0.675840415460787, 1.30657907092168, 1.64810139626585, 
2.04212723356586, 2.66056776532775, 3.78753790421503, 8.53922847595784, 
21.1541280645958, 33.7371457369047, 48.9875802648531, 66.9431017376182, 
94.0032520809409, 165.723932695121, 245.598387008322), `1000` = c(1000, 
0.672525283346607, 1.31610886967128, 1.65049053857724, 2.03580193850619, 
2.64001441933625, 3.82888572913011, 8.62801341605654, 21.5655364609746, 
34.2497810388054, 49.4081675180479, 67.1088208929885, 95.804137908048, 
167.932906806478, 291.483436589401), `1250` = c(1250, 0.7407466176107, 
1.3337353248466, 1.67724864033851, 2.07287011315128, 2.70810479663192, 
3.85021716960402, 8.6759735666651, 21.4399104286228, 34.367864784182, 
49.8731322659698, 67.9241591648535, 95.2495997369313, 176.691645517416, 
244.034782349468), `2500` = c(2500, 0.675518625055808, 1.33368882838333, 
1.68265645154853, 2.06039289391705, 2.68819749443941, 3.86333765228147, 
8.71019616325151, 21.5463829066756, 35.0497499892926, 50.3445699503282, 
69.0720626677329, 94.1117432628981, 167.731713289658, 231.630106373227
)), .Names = c("quantile", "25", "50", "100", "250", "500", "750", 
"1000", "1250", "2500"), row.names = c("", "0.01%", "1%", "2.5%", 
"5%", "10%", "20%", "50%", "80%", "90%", "95%", "97.5%", "99%", 
"99.9%", "99.99%"), class = "data.frame")
    
# The following table was generated using the call
#  egc_ersd_qtab <- egc_quantile_table("ers-d")
egc_ersd_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-5.10048956847502, -3.30687485693397, -2.90155974190788, -2.59129558300045, 
-2.27276240072175, -1.92213650552829, -1.34798299473902, -0.838329861629613, 
-0.509185593064544, -0.195300939641466, 0.108914109087463, 0.482149591268087, 
1.32699563522915, 2.10728039324104), `50` = c(50, -4.6199438788185, 
-3.21676499222889, -2.8686006810382, -2.59803884713455, -2.29576353217148, 
-1.94583374315336, -1.33829556692924, -0.781175098555971, -0.397080658949842, 
-0.0296455279811186, 0.32631220386273, 0.734690136808975, 1.62622811094037, 
2.24605507511686), `100` = c(100, -4.51297528529818, -3.17156669441703, 
-2.83736242414913, -2.55094926095896, -2.24977219003744, -1.88595137575393, 
-1.24474595982246, -0.638191937730234, -0.233009600573567, 0.160302569814843, 
0.51339966804765, 0.951450453947234, 1.81236847378032, 2.69868923028809
), `250` = c(250, -4.37525803985682, -3.11239840487866, -2.80614575845577, 
-2.53816683428338, -2.20592284886742, -1.83484806078488, -1.1468850571759, 
-0.491236431122179, -0.0764269107363089, 0.312863660226734, 0.666606184291284, 
1.10400057132307, 1.9447657288027, 2.77038477905867), `500` = c(500, 
-4.25804077548967, -3.12780400002265, -2.81162151984338, -2.52181493428759, 
-2.18877158176733, -1.7876628512075, -1.08682320198154, -0.405262455957855, 
0.0217186030751472, 0.389864188676898, 0.738630355309322, 1.15496529052512, 
2.05416971254848, 2.90495065530857), `750` = c(750, -4.36147063522307, 
-3.14245449845762, -2.78950724295031, -2.48675051561575, -2.1653912230568, 
-1.78073016343705, -1.06913732108122, -0.381437995991238, 0.0484265194036463, 
0.434833031029738, 0.77225944105774, 1.18255474811806, 1.99386245001663, 
2.80529292874148), `1000` = c(1000, -4.50739170629214, -3.13712650619975, 
-2.80431314786342, -2.50954785628484, -2.18074731078809, -1.78467925508109, 
-1.07259971623705, -0.382209469861783, 0.0576012359080366, 0.435548812016741, 
0.800719533205871, 1.18775043814421, 2.08391466082401, 2.78987232526501
), `1250` = c(1250, -4.52635229954304, -3.12054809254334, -2.8022823402926, 
-2.5028174903535, -2.16809873100608, -1.77226225298197, -1.06144666113106, 
-0.368677919111695, 0.0550234663325856, 0.445648528283737, 0.807052347089671, 
1.19924309600821, 1.96541372814745, 2.62092875436772), `2500` = c(2500, 
-4.47168620669166, -3.13545292848152, -2.78588889223927, -2.4880731613059, 
-2.15658084744067, -1.77365567712487, -1.04468871221604, -0.353635563847591, 
0.0725063965562995, 0.464447482050564, 0.817423489553938, 1.21452650295202, 
2.16613650569432, 2.8166674020312)), .Names = c("quantile", "25", 
"50", "100", "250", "500", "750", "1000", "1250", "2500"), row.names = c("", 
"0.01%", "1%", "2.5%", "5%", "10%", "20%", "50%", "80%", "90%", 
"95%", "97.5%", "99%", "99.9%", "99.99%"), class = "data.frame")

# The following table was generated using the call
#  egc_spr_qtab <- egc_quantile_table("sp-r")
egc_spr_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-52.6580674935556, -22.3861520557875, -17.3864412906388, -14.421268812453, 
-11.7167753282881, -9.29292285283269, -4.79260434274902, 0.887548308645351, 
4.01376339096833, 7.02231750883232, 10.4327290224018, 15.2686651172952, 
27.2684638444846, 38.4394696796664), `50` = c(50, -61.4048593121644, 
-26.061017492712, -22.0403196103959, -19.2546202797511, -16.7412908851307, 
-14.226477705248, -9.22334190406295, -4.13202874459074, -1.40276812028152, 
0.592906112391562, 2.20918217496902, 4.3072581136573, 11.1808081177222, 
20.2478559929431), `100` = c(100, -50.3039002015622, -29.7328726027708, 
-26.729419424891, -24.2759372390848, -21.397555121129, -17.8587238673482, 
-11.0925227673756, -5.4046402185745, -3.14839559931649, -1.37810591698949, 
-0.0718170814128574, 1.45388853258661, 4.16593145701825, 6.41447232441966
), `250` = c(250, -55.4541916697354, -37.2633198539768, -32.321570871558, 
-28.1076003621881, -23.4690564850126, -18.4305177297307, -10.5321701441243, 
-5.21312276162628, -3.23732701223692, -1.89619562108202, -0.877880133453622, 
0.290011112144745, 2.73355064701423, 4.28148964963558), `500` = c(500, 
-65.196373572361, -38.5196597911918, -32.6934163091834, -27.6488708555601, 
-22.6425190442907, -17.3691458046934, -9.73585377523323, -4.95817126843802, 
-3.29752837863405, -2.16705673928955, -1.3550483851403, -0.427178605258981, 
1.54421759509182, 3.04795877851944), `750` = c(750, -66.2992118292477, 
-37.4258899749959, -31.4471300098562, -26.6263907489262, -21.7164895305755, 
-16.7450987696474, -9.44524927775992, -4.96136619440135, -3.38343701051509, 
-2.39004400329423, -1.6405952088073, -0.899695677497808, 1.01592238207383, 
2.62243764809039), `1000` = c(1000, -63.3941453684708, -36.8083513432148, 
-30.7371264951546, -26.2579808522556, -21.3233625045404, -16.3143971164037, 
-9.26471707284782, -4.94645341482234, -3.4552037954847, -2.49010210001177, 
-1.78806974309296, -1.0304334433519, 0.43986080730562, 2.46811417886369
), `1250` = c(1250, -66.3973686585401, -36.3669268158086, -29.9693035813389, 
-25.525069041783, -20.7584281320636, -16.0088474590749, -9.09579226688802, 
-4.91825731265008, -3.46908764338723, -2.57307710737357, -1.94111393050574, 
-1.27888612803405, 0.0158725164487333, 1.71854940369779), `2500` = c(2500, 
-57.280232462311, -34.3510602355879, -28.2346144973038, -24.019011625483, 
-19.7639564036047, -15.3006473206934, -8.95370586432994, -5.00062203171719, 
-3.65859256643428, -2.80814433773019, -2.21352451614216, -1.67558352731201, 
-0.826952287157412, -0.0526180736698275)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#  egc_bvr_qtab <- egc_quantile_table("bvr")
egc_bvr_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
0.00175316032383965, 0.00372824609873825, 0.00474477225593607, 
0.00605469351971975, 0.00812844997687993, 0.0115842364885377, 
0.0236518010608536, 0.0515055182026042, 0.0679116332488497, 0.078356862924516, 
0.0849650741569281, 0.090225525270155, 0.0962490330322663, 0.0985873233848373
), `50` = c(50, 0.00125878578262598, 0.00348407042704959, 0.00453078060718951, 
0.00582061896831429, 0.00776085926148126, 0.0112502774429388, 
0.0230665927673575, 0.0513883374845921, 0.0676540246205908, 0.0783421750552322, 
0.0852850990434269, 0.0905302715688617, 0.0961929557175782, 0.0985464434960829
), `100` = c(100, 0.00126646991292459, 0.00341968283729603, 0.00446998420728161, 
0.00573010282121679, 0.00767810999346112, 0.0111811961826295, 
0.0230085832403671, 0.0509842648495735, 0.0674163682329703, 0.0776298692537992, 
0.0845763483455989, 0.0898956331467927, 0.0960783984315815, 0.0981374793725492
), `250` = c(250, 0.00135394709228181, 0.00336084540489899, 0.00444187864153149, 
0.00572264179835361, 0.00769140460909738, 0.011271757062258, 
0.0232564240121588, 0.0512742310299524, 0.0674040655759355, 0.0778059485881525, 
0.0845685557194811, 0.0900789327685887, 0.0965728744630847, 0.0985924133966425
), `500` = c(500, 0.00133278513978836, 0.0033785281442177, 0.00443291182155661, 
0.00566730197704589, 0.00759119298969563, 0.011106158112734, 
0.0229299610528671, 0.0512804516178702, 0.0677306565298591, 0.0780913392144301, 
0.0847229710024254, 0.0898507154096893, 0.0960716024468816, 0.0979756395318706
), `750` = c(750, 0.00127271754613132, 0.00334326253946835, 0.0044376058858092, 
0.00567836549601221, 0.00765416488538404, 0.011082843605444, 
0.0233006332222607, 0.0510644551700367, 0.0672474116720296, 0.0779029087903253, 
0.0847543574346385, 0.090129611707222, 0.0959893874257297, 0.0982990865065379
), `1000` = c(1000, 0.00142855861269069, 0.00337982782600337, 
0.00448136029314251, 0.00574442680663723, 0.00770970877283258, 
0.0111369411954928, 0.0231006399903615, 0.0512968649949992, 0.0678321175431207, 
0.0782466142059317, 0.0847527233328217, 0.0899530004868225, 0.0961991259484588, 
0.0985702560735901), `1250` = c(1250, 0.0012216250863014, 0.00335627004382164, 
0.00436451873181917, 0.00562010410578463, 0.00754792233150499, 
0.0110624813220342, 0.023034471259804, 0.0511554847291635, 0.0675896285434318, 
0.078123386919052, 0.0849540685548403, 0.0903162236226654, 0.0959418515751104, 
0.0980227647050528), `2500` = c(2500, 0.0013993685161291, 0.00328278081675422, 
0.00431275840777267, 0.00561088622839673, 0.00756357885754346, 
0.0109304449056177, 0.022806018819766, 0.0510722515356924, 0.0673052939402961, 
0.0780119775067037, 0.0853537397114059, 0.0904679666300433, 0.0963781569645721, 
0.0984251958126395)), .Names = c("quantile", "25", "50", "100", 
"250", "500", "750", "1000", "1250", "2500"), row.names = c("", 
"0.01%", "1%", "2.5%", "5%", "10%", "20%", "50%", "80%", "90%", 
"95%", "97.5%", "99%", "99.9%", "99.99%"), class = "data.frame")

# The following table was generated using the call
#  egc_hurst_qtab <- egc_quantile_table("hurst")
egc_hurst_qtab <- structure(list(quantile = c(NA, 1e-04, 0.01, 0.025, 0.05, 0.1, 
0.2, 0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999, 0.9999), `25` = c(25, 
-0.0857104154562339, 0.133210430518201, 0.21757158740498, 0.302075666405815, 
0.412288002210507, 0.553737145487023, 0.791999850979961, 0.942408563459437, 
1.03752728028492, 1.12334551390639, 1.199364751987, 1.28935644406156, 
1.4788624374248, 1.60281934898386), `50` = c(50, -0.210510546641782, 
0.148521159926177, 0.236754966586507, 0.323062917034732, 0.440561238949842, 
0.594449346643995, 0.84533338685408, 1.00872532552355, 1.11525381376523, 
1.21124630034875, 1.30240701508315, 1.40066986434104, 1.62933879134307, 
1.8094532095276), `100` = c(100, 0.608421115688707, 0.669202684672745, 
0.686948091874949, 0.700910235690267, 0.715981989608048, 0.732675795425451, 
0.760742665529899, 0.781868065454202, 0.789995593503324, 0.795612443670174, 
0.79985565918484, 0.803871575777497, 0.81053430524587, 0.815683684905914
), `250` = c(250, 0.163269417202177, 0.468343963677446, 0.551403486545482, 
0.621721912274676, 0.701300434805828, 0.791575778983888, 0.943450340354443, 
1.08072919858757, 1.15474890396131, 1.22024784792747, 1.27890268009899, 
1.34897113478298, 1.50453730320009, 1.62350434114705), `500` = c(500, 
0.559821127511552, 0.725366407087795, 0.769498711209786, 0.807570807014315, 
0.84517688925953, 0.889458303519949, 0.962545489649822, 1.01986609022312, 
1.0447836625327, 1.06412850568638, 1.08008137635462, 1.09924572004341, 
1.13485895275615, 1.16740085470259), `750` = c(750, 0.613233960522025, 
0.768266005282359, 0.805138052711843, 0.836850174698671, 0.870473987153841, 
0.90751086837418, 0.969648390381694, 1.02048326095553, 1.04257998217263, 
1.06035119480173, 1.0749212161725, 1.09030322468911, 1.12030671140103, 
1.14546764647775), `1000` = c(1000, 0.713557916770165, 0.817283421433091, 
0.84735474432992, 0.870552278042612, 0.895823505927616, 0.924013441406549, 
0.972003562463966, 1.01082965461448, 1.02756833257899, 1.04009340082773, 
1.04991743010241, 1.06078782385471, 1.08116709724364, 1.10024285919318
), `1250` = c(1250, 0.727861621992402, 0.837966899914253, 0.864397997075103, 
0.885051362719385, 0.907783875060897, 0.933022641336332, 0.974397559319962, 
1.00754132228889, 1.02207876108799, 1.03280811634587, 1.04144166798579, 
1.05119068751227, 1.07004005063871, 1.08337318531449), `2500` = c(2500, 
0.8270940813197, 0.889562819032396, 0.906227552056674, 0.920370911743679, 
0.935778423042475, 0.952502655811722, 0.979690819213283, 1.00138535875713, 
1.01113849483358, 1.01809429851473, 1.02371056339248, 1.02945727068189, 
1.04114161876617, 1.04932093345531)), .Names = c("quantile", 
"25", "50", "100", "250", "500", "750", "1000", "1250", "2500"
), row.names = c("", "0.01%", "1%", "2.5%", "5%", "10%", "20%", 
"50%", "80%", "90%", "95%", "97.5%", "99%", "99.9%", "99.99%"
), class = "data.frame")

# The following table was generated using the call
#   rho_bias_qtab <- generate_rho_bias_table()
rho_bias_qtab <- structure(c(NA, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.85, 
0.9, 0.91, 0.92, 0.93, 0.94, 0.95, 0.96, 0.97, 0.98, 0.99, 1, 
25, 0.00579626402932596, 0.0890590962172455, 0.171824874686124, 
0.251044677515644, 0.330764203025436, 0.405704835424967, 0.475061717710669, 
0.541808016810147, 0.571735804493515, 0.60565221599304, 0.612682474856749, 
0.619987042965707, 0.625029123229028, 0.632288580912326, 0.635008192179664, 
0.646238773757011, 0.651437052422971, 0.657927899022773, 0.667817263227693, 
0.672961524124665, 50, 0.0541200753802938, 0.144640150821975, 
0.235892360611822, 0.325879291413036, 0.41680267199482, 0.50415885702723, 
0.588396212791385, 0.6740485464077, 0.71196928363215, 0.75104316423088, 
0.760979456066076, 0.766067337337698, 0.771364755676878, 0.779816398200369, 
0.785651205150849, 0.794421953991002, 0.803023539408362, 0.811087774056031, 
0.81967359452155, 0.827239823674534, 100, 0.0763382548072746, 
0.171563568987254, 0.266425445954362, 0.363775028318011, 0.459018061866415, 
0.551919940061675, 0.645037307308082, 0.739174729313482, 0.782816392968272, 
0.827396377481796, 0.835864190196367, 0.844726057133227, 0.852873925321447, 
0.861127936107442, 0.869938168307618, 0.877156691844852, 0.884687497867436, 
0.894722344757547, 0.902689193366767, 0.911350711059478, 200, 
0.087114208110281, 0.186016801663539, 0.283912989935641, 0.382085135535338, 
0.478690277940978, 0.576395103301607, 0.672975898263338, 0.77073179314775, 
0.818743839975534, 0.865734334714667, 0.873894552241051, 0.883964126784713, 
0.89339587111815, 0.901890231334893, 0.911357373612709, 0.920054300498443, 
0.928996558707903, 0.937506720571201, 0.945549386762055, 0.955551294268134, 
400, 0.0940012978016627, 0.192671732277283, 0.291295089562392, 
0.391330078301239, 0.489821049976308, 0.587921411146489, 0.686678482651164, 
0.784917921704036, 0.834510089809465, 0.883079850902787, 0.893384611054417, 
0.902728346204853, 0.912437644586801, 0.922288368568395, 0.9313875631715, 
0.940933255717854, 0.950449393241092, 0.959701555797522, 0.968454005816006, 
0.977142238885091, 800, 0.0968384455762118, 0.196074149282283, 
0.295709004626325, 0.395445405898641, 0.495164855910322, 0.595000938146491, 
0.69404623598311, 0.792081225218621, 0.841700021015024, 0.891709672415359, 
0.901715294627787, 0.911789232267656, 0.92120837824092, 0.93143708397091, 
0.94120355072721, 0.9511699215617, 0.960582362268785, 0.97036408365614, 
0.979744639399311, 0.988550300982111, 1200, 0.0983826928642641, 
0.197569144039095, 0.297611810574128, 0.397267020262764, 0.496708586841542, 
0.596078529037621, 0.695410540033741, 0.795106541068475, 0.844944485954799, 
0.894523254206652, 0.90442222816685, 0.914444804451488, 0.924269988662038, 
0.934192504230248, 0.944269402689644, 0.954136229383738, 0.963899750318928, 
0.973770779185442, 0.983388098992297, 0.992459714269753, 1600, 
0.0988539653135237, 0.198498983488058, 0.298226285609526, 0.398016646971277, 
0.49693043926081, 0.596709186175247, 0.696654320053202, 0.796436355580036, 
0.84632782271299, 0.895920019427508, 0.906039442133343, 0.915759135965388, 
0.925843045012764, 0.935766422671986, 0.945614498189454, 0.95563174528189, 
0.965547234932824, 0.97539219220646, 0.985112331636528, 0.994337351609841, 
2000, 0.0984872136826968, 0.198566209126483, 0.298512558402136, 
0.397919485467869, 0.498188663157584, 0.597854944882431, 0.697221012623204, 
0.797359362655975, 0.84692400802886, 0.89681846757967, 0.906888349658203, 
0.916805348446773, 0.926715861630496, 0.936635442905022, 0.946764917293779, 
0.95645907431767, 0.966473528913937, 0.97638570289554, 0.986138462304169, 
0.995504007250361), .Dim = c(21L, 10L), .Dimnames = list(c("", 
"0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.85", 
"0.9", "0.91", "0.92", "0.93", "0.94", "0.95", "0.96", "0.97", 
"0.98", "0.99", "1"), c("quantile", "25", "50", "100", "200", 
"400", "800", "1200", "1600", "2000")))

# This table is generated through the following steps:
#   cbtab <- coint_bias_table(sample_size=c(25,50,100,200,400,800,1200,1600,2000))
#   rho_bias_ltab <<- cbtab_to_rhobtab(cbtab)

# rho_bias_ltab <- structure(list(
# n =       c(25,      50,     100,     200,     400,     800,    1200,    1600,    2000), 
# c0 = c(0.08060, 0.03249, 0.01528, 0.00929, 0.00409, 0.00318, 0.00155, 0.00131, 0.00097),
# c1 = c(1.32771, 1.15184, 1.06583, 1.02898, 1.01415, 1.00517, 1.00441, 1.00238, 1.00258)),
# .Names = c("n", "c0", "c1"), 
# row.names = c(NA, 9L), class = "data.frame")

rho_bias_ltab <- structure(list(n = c(25, 50, 100, 200, 400, 800, 1200, 1600, 
2000), c0 = c(0.0814875102581547, 0.0348936698142133, 0.0191890654195977, 
0.00827078048614661, 0.00349860867799339, 0.00201210403167159, 
0.00174662084510353, 0.00132323010209433, 0.000815444688383991
), c1 = c(1.22568817222908, 1.10252163308562, 1.0454757586257, 
1.02296381021271, 1.01182912101022, 1.00533407590582, 1.00392839598619, 
1.00300066638024, 1.00253862516874)), .Names = c("n", "c0", "c1"
), row.names = c(NA, -9L), class = "data.frame")

