% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_d.R
\name{interpret_d}
\alias{interpret_d}
\alias{interpret_g}
\alias{interpret_delta}
\title{Standardized difference interpretation}
\usage{
interpret_d(d, rules = "funder2019")

interpret_g(g, rules = "funder2019")

interpret_delta(delta, rules = "funder2019")
}
\arguments{
\item{d, g, delta}{Value or vector of effect size values.}

\item{rules}{Can be \code{"funder2019"} (default), \code{"gignac2016"}, \code{"cohen1988"}, \code{"sawilowsky2009"} or custom set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpretation of indices using different sets of rules of thumb.
\href{https://easystats.github.io/report/articles/interpret_metrics.html#standardized-difference-d-cohens-d}{Click here} for details.
}
\examples{
interpret_d(.02)
interpret_d(c(.5, .02))

}
\references{
\itemize{
\item Funder, D. C., & Ozer, D. J. (2019). Evaluating effect size in psychological research: sense and nonsense. Advances in Methods and Practices in Psychological Science.
\item Gignac, G. E., & Szodorai, E. T. (2016). Effect size guidelines for individual differences researchers. Personality and individual differences, 102, 74-78.
\item Cohen, J. (1988). Statistical power analysis for the behavioural sciences.
\item Sawilowsky, S. S. (2009). New effect size rules of thumb.
}
}
