% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-download.R
\name{nat_data_download}
\alias{nat_data_download}
\title{Download a data frame containing electorate centroids}
\usage{
nat_data_download(year, ...)
}
\arguments{
\item{year}{Desired year, must be one of 2001, 2004, 2007, 2010, 2011, 2013, 2016, 2019}

\item{...}{Additional arguments passed to `download.file`}
}
\value{
A data frame with data associated with each of the Australian federal electorates

\itemize{
    \item id: Numeric identifier for the polygon
    \item elect_div: Electorate division name   
    \item state: abbreviation of the state name
    \item numccds: AEC variable that might be filled with meaning or a description down the road
    \item area_sqkm: combined square kilometers of each electorate
    \item long_c: longitude coordinate of electorate (polygon) centroid
    \item lat_c: latitude coordinate of electorate (polygon) centroid
    \item x: latitude coordinate for plotting a cartogram
    \item y: longitude coordinate for plotting a cartogram
    \item radius: variable used in the construction of cartogram points
}
}
\description{
Downloads and returns a data frame containing the points that make up the centroids
for each of the Australian electorates in the desired federal election.
}
\examples{
library(eechidna)
library(dplyr)
library(ggmap)

nat_data19 <- nat_data_download(2019)

nat_data19 \%>\%
  qmplot(long_c, lat_c, data=.)
}
