% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapefiles.R
\name{get_electorate_shapes}
\alias{get_electorate_shapes}
\title{Extract shapefiles (of Australian electorates) from raw file into fortified
map and data components.}
\usage{
get_electorate_shapes(
  path_to_shapeFile = NULL,
  sF = NULL,
  mapinfo = TRUE,
  layer = NULL,
  tolerance = 0.005
)
}
\arguments{
\item{path_to_shapeFile}{path to object in local machine (only if shapefile has not already loaded)}

\item{sF}{Shapefile object loaded to environment using load_shapefile}

\item{mapinfo}{Is the data mapInfo format, rather than ESRI? default=TRUE}

\item{layer}{If the format is mapInfo, the layer name also needs to be provided, default is NULL}

\item{tolerance}{Numerical tolerance value to be used by the Douglas-Peuker algorithm (only if shapefile has not already loaded)}
}
\value{
list with two data frames: map and data; `map` is a data set with geographic latitude and longitude, and a grouping variable to define each entity.
The `data` data set consists of demographic or geographic information for each electorate, such as size in square kilometers or corresponding state.
Additionally, geographic latitude and longitude of the electorate's centroid are added.
}
\description{
Extract polygon information and demographics for each of Australia's electorates. 
The map and data corresponding to the shapefiles of the 2013 Australian electorates (available at \url{https://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}) are part of this package as nat_map.rda and nat_data.rda in the data folder.
The function will take several minutes to complete.
}
\examples{
\dontrun{
# Get electorate shapes in data.frame format

# Path to your shapefile
fl <- "local/path/to/shapefile.shp"

map_and_data16 <- get_electorate_shapes(path_to_shapefile = fl)
}
}
