% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreignTbl.R
\name{foreignTbl}
\alias{foreignTbl}
\title{Create a foreign tibble}
\usage{
foreignTbl(
  x,
  y,
  by = intersect(dplyr::tbl_vars(x), dplyr::tbl_vars(y)),
  naturalKey = dplyr::tbl_vars(y),
  allowNew = FALSE
)
}
\arguments{
\item{x}{\code{tbl}. The referencing table.}

\item{y}{\code{tbl}. The referenced table.}

\item{by}{\code{character}. Column names to match on.
Note that you should rename and/or typecast the columns in y should they not exactly match the columns in x.}

\item{naturalKey}{\code{character}. The columns that form the natural key in y.
These are the only ones that can actually get modified in \code{eDT}, other columns will be deducted from these.}

\item{allowNew}{\code{logical}. Whether or not new values are allowed. If \code{TRUE},
the rows in the foreignTbl will only be used as suggestions, not restrictions.}
}
\value{
List with unmodified arguments. However, they have now been checked for validity.
\itemize{
\item y, see argument \code{y}.
\item by, see argument \code{by}.
\item naturalKey, see argument \code{naturalKey}.
\item allowNew, see argument \code{allowNew}
}
}
\description{
Create a foreign tibble
}
\details{
This is a tibble that can be passed onto \code{\link{eDT}} as a referenced table.

It is the equivalent of a database table to which the \code{data} tbl of eDT has a foreign key.

It will be merged with the tbl passed onto the \code{data} argument allowing to provide restrictions
for certain columns.

Note that row uniqueness for the columns used in \code{by} and \code{naturalKey} is assumed.
This assumption will however not be checked since it is an expensive operation on big datasets.
However, if violated, it might give errors or unexpected results during usage of the eDT module.
}
\examples{
a <- tibble::tibble(
   first_name = c("Albert","Donald","Mickey"),
   last_name_id = c(1,2,2)
 )

b <-  foreignTbl(
 a,
 tibble::tibble(
     last_name = c("Einstein", "Duck", "Mouse"),
     last_name_id = c(1,2,3)
   ),
 by = "last_name_id",
 naturalKey = "last_name"
)

## Only run this in interactive R sessions
if(interactive()){
  eDT(a,
   foreignTbls = list(b),
   options = list(columnDefs = list(list(visible=FALSE, targets="last_name_id")))
  )
 }


}
\author{
Jasper Schelfhout
}
