% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWordcloud.R
\name{getWordcloud}
\alias{getWordcloud}
\title{Creates wordcloud of words from EDGAR filing.}
\usage{
getWordcloud(word.frq, words.list)
}
\arguments{
\item{word.frq}{Word frequency dataframe created using 
\link[edgar]{getWordfrquency} function.}

\item{words.list}{Word list as a sentiment dictionary.}
}
\value{
Function creates wordcloud.
}
\description{
\code{getWordcloud} creates wordcloud of words from filing.
}
\details{
getWordcloud function takes words frequency dataframe as an input from 
\link[edgar]{getWordfrquency} function. It compares these words 
with the input dictionary and generates wordcloud using match words.
}
\examples{
\dontrun{

words.list <- scan(system.file('data/negwords.txt', package = 'edgar'), what='character')
## User can apply any desired user defined dictionary other than 
## default dictionaries from this package.

getWordcloud(word.frq, words.list)
}

}
