% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCompustat.R
\name{mergeCompustat}
\alias{mergeCompustat}
\title{Connect sentiment count of multiple cik's 10-K filing with compustat data.}
\usage{
mergeCompustat (cik.no, filing.yr, words.list, compustat.data)
}
\arguments{
\item{cik.no}{cik number.}

\item{filing.yr}{10-K filing year.}

\item{words.list}{sentiment dictionary in list format.}

\item{compustat.data}{compustat data frame.}
}
\value{
Compustat data with sentiment.count column for desired cik and filing year.
}
\description{
\code{mergeCompustat} merge sentiment count of 10-K filing with compustat data.
}
\details{
mergeCompustat function takes cik number, filing year, sentiment dictionary, and  
compustat data. It download and parse 10-K filing for desired cik and filing year  
present in input compustat dataset. It count sentiment words present in defined 10-K 
and append to compustat data frame. Working directory must contain 'Master Index' 
directory which contains master Rda files for specified filing year. This master index
can be downloaded using \link[edgar]{getMasterIndex} function.
}
\examples{
\dontrun{

compustat.data <- read.csv('compustat_data.csv')
## User needs to input compustat data in data frame format.

words.list <- scan(system.file('data/negwords.txt', package = 'edgar'), what='character')
## USer can apply any desired user defined dictionary other than 
## default dictionaries from this package.

## For single cik
res <- mergeCompustat <- function( 2098, 2014, words.list, compustat.data)

# User can provide list of different CIK's.
cik.no <- c(1750,6201,2098)
res <- mergeCompustat <- function( cik.no, 2014, words.list, compustat.data)
 
}

}

