% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_selfloops.R
\name{number_of_selfloops}
\alias{number_of_selfloops}
\alias{number_of_selfloops.eventlog}
\alias{number_of_selfloops.grouped_eventlog}
\alias{number_of_selfloops.activitylog}
\alias{number_of_selfloops.grouped_activitylog}
\title{Number of Self-loops}
\usage{
number_of_selfloops(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  sort = TRUE,
  eventlog = deprecated()
)

\method{number_of_selfloops}{eventlog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  sort = TRUE,
  eventlog = deprecated()
)

\method{number_of_selfloops}{grouped_eventlog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  sort = TRUE,
  eventlog = deprecated()
)

\method{number_of_selfloops}{activitylog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  sort = TRUE,
  eventlog = deprecated()
)

\method{number_of_selfloops}{grouped_activitylog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  sort = TRUE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{type}{\code{\link{character}} (default \code{"all"}): The type of repetitions: \code{"all"} (default),
\code{"repeat"}, or \code{"redo"}. For more information, see 'Details' below.}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}

\item{append}{\code{\link{logical}} (default \code{FALSE}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: Indicating whether to append
results to original log. Ignored when level is \code{"log"} or \code{"trace"}.}

\item{append_column}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Which of the output columns to append to log, if \code{append = TRUE}. Default column depends on chosen level.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort output on count. Only for levels with frequency count output.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
Provides information statistics on the number of self-loops in a trace.

Activity instances of the same activity type that are executed more than once immediately after each other by the same
resource are in a self-loop ("length-1-loop"). If an activity instance of the same activity type is executed 3 times
after each other by the same resource, this is defined as a "size 2 self-loop".
}
\details{
Two types of self-loops are defined, which can be chosen using the \code{type} argument:
\itemize{
\item \code{"repeat"} self-loops are activity executions of the same activity type that are executed immediately following
each other by the same resource.
\item \code{"redo"} self-loops are activity executions of the same activity type that are executed immediately following
each other by a different resource.
}

Argument \code{level} has the following options:
\itemize{
\item At \code{"log"} level, the summary statistics of the number of self-loops within a trace can give a first insight
in the amount of waste in a log. As stated earlier, each combination of two occurrences of the same activity executed
by the same resource will be counted as one repeat self-loop of this activity.
\item On \code{"case"} level, an overview is provided of the absolute and relative number of repeat and redo self-loops
in each case. To calculate the relative number, each (repeat or redo) self-loop is counted as 1 occurrence, and the other
activity instances are also counted as 1.
\item On \code{"activity"} level, the absolute and relative number of self-loops per activity can be an indication for
which activities are causing the most waste in the process.
\item On \code{"resource"} level, this metric can give insights into which resources needs to repeat their work most often
within a case, or for which resource the work they did should be redone by another resource within the same case.
This metric shows the absolute and relative number of both repeat and redo self-loops for each resource in the log.
\item On \code{"resource-activity"} level, this metric can be used to get an insight in which activities are the most
crucial for which resources. This metric shows the absolute and relative number of both repeat and redo self-loops for
each of the resource-activity combinations that occur in the log. Two different relative numbers are provided here,
one from the resource perspective and one from the activity perspective. At the resource perspective, the denominator
is the total number of executions by the resource under consideration. At the activity perspective, the denominator
is the total number of occurrences of the activity under consideration.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Computes the number of self-loops for an \code{\link[bupaR]{eventlog}}.

\item \code{grouped_eventlog}: Computes the number of self-loops for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{activitylog}: Computes the number of self-loops for an \code{\link[bupaR]{activitylog}}.

\item \code{grouped_activitylog}: Computes the number of self-loops for a \code{\link[bupaR]{grouped_activitylog}}.
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{number_of_repetitions}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_traces}()},
\code{\link{processing_time}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
