% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.synchronous.R
\name{is.synchronous}
\alias{is.synchronous}
\title{Synchronicity in trajectory observations}
\usage{
is.synchronous(x)
}
\arguments{
\item{x}{An object of class \code{trajectories} (or its children subclasses \code{fd.trajectories} or \code{cycles})}
}
\value{
A boolean indicating whether trajectories are synchronous
}
\description{
Checks whether trajectories are synchronous, meaning that observation times are equal
}
\examples{
#Description of sites and surveys
sites <- c("1","1","1","2","2","2")
surveys <- c(1,2,3,1,2,3)
  
#Raw data table
xy<-matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1

#Synchronous trajectories
x1 <- defineTrajectories(dist(xy), sites, surveys)
is.synchronous(x1)

# Non synchronous trajectories
x2 <- defineTrajectories(dist(xy[1:5,]), sites[1:5], surveys[1:5])
is.synchronous(x2)
}
\seealso{
\code{\link{defineTrajectories}}
}
