% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parse_raster_dates}
\alias{parse_raster_dates}
\title{Parse weekly dates from raster layer names}
\usage{
parse_raster_dates(x)
}
\arguments{
\item{x}{\link[terra:SpatRaster-class]{SpatRaster} object; weekly Status and Trends
data cube.}
}
\value{
Date vector.
}
\description{
The dates corresponding to each layer of a weekly data cube are stored as
the layer names. This function converts these to Date objects.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# weekly relative abundance
abd_weekly <- load_raster(path, "abundance", resolution = "lr")

# dates corresponding to each week
parse_raster_dates(abd_weekly)
}
}
