% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stixelize.R
\name{stixelize}
\alias{stixelize}
\alias{stixelize.data.frame}
\alias{stixelize.sf}
\title{Generate stixel polygons from PI data}
\usage{
stixelize(x)

\method{stixelize}{data.frame}(x)

\method{stixelize}{sf}(x)
}
\arguments{
\item{x}{\code{data.frame} or \link{sf} object; PI data loaded with \code{\link[=load_pis]{load_pis()}}, or
any other data frame with fields \code{lon}, \code{lat}, \code{stixel_width}, and
\code{stixel_hight}.}
}
\value{
\link{sf} object with geometry column storing polygons representing the
stixels boundaries.
}
\description{
All predictor importance data are provided at the stixel level. In these
files, the stixel is defined based on a centroid, width, and height. This
function uses this information to define polygons for each stixel and
attaches them to the original data in the form of an \link{sf} object
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: PI or PD data

\item \code{sf}: PI or PD data as \code{sf} object
}}

\examples{
\dontrun{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# load predictor importance
pis <- load_pis(sp_path)

stixelize(pis)

# also works on sf objects
pis_sf <- sf::st_as_sf(pis, coords = c("lon", "lat"), crs = 4326)
stixelize(pis_sf)
}
}
