% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-plotting.R
\name{convert_classes}
\alias{convert_classes}
\title{Converts cryptic cover class names to readable land cover names}
\usage{
convert_classes(x, by_cover_class = FALSE, pretty = FALSE)
}
\arguments{
\item{x}{character; vector of land cover variable names to convert.}

\item{by_cover_class}{logical; whether to replace FRAGSTATS cover class name
with a name for the cover class as whole.}

\item{pretty}{logical; whether to convert from capital case to title case.}
}
\value{
A vector of converted names.
}
\description{
Internal function that converts the cryptic predictor class names to
readable land cover names.
}
\examples{
predictors <- c("UMD_FS_C1_1500_PLAND", "MODISWATER_FS_C7_1500_LPI", "ELEV")
ebirdst:::convert_classes(predictors, pretty = TRUE)
}
\keyword{internal}
