% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelsGADS.R
\name{labelsGADS}
\alias{labelsGADS}
\title{Labels from relational \code{eatGADS} data base.}
\usage{
labelsGADS(filePath)
}
\arguments{
\item{filePath}{Path of the existing \code{eatGADS} data base.}
}
\value{
Returns a long format data frame including variable names, labels, values, value labels and missing labels.
}
\description{
Returns the variable and value labels of all variables in the \code{eatGADS} data base.
}
\details{
Variable, value and missing labels as stored in the original SPSS-files and factors from R files are converted to long format for
storage in the data base. \code{labelsGADS} returns them as a long format data frame.
}
\examples{
# Extract Meta data from data base
db_path <- system.file("extdata", "pisa.db", package = "eatGADS")
metaData <- labelsGADS(db_path)

}
