% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acrossFormsConstraint.R
\name{acrossFormsConstraint}
\alias{acrossFormsConstraint}
\title{Constrain the sum of item values across multiple forms.}
\usage{
acrossFormsConstraint(
  nForms,
  nItems = NULL,
  operator = c("<=", "=", ">="),
  targetValue,
  whichForms = seq_len(nForms),
  whichItems = NULL,
  itemIDs = NULL,
  itemValues = NULL,
  info_text = NULL
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool [optional to create \code{itemIDs} automatically].}

\item{operator}{A character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{the target value. The target sum of item values across
test forms.}

\item{whichForms}{An integer vector indicating across which test forms the
sum should constrained. Defaults to all the test forms.}

\item{whichItems}{A vector indicating which items should be constrained. Defaults to all the items.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}

\item{itemValues}{a vector of item values for which the sum across test forms should be constrained. The item values will be repeated for each form. Defaults to a vector with ones for all items in the pool.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create constraints related to item values. That is, the created
constraints assure that the sum of the item values (\code{itemValues}) across test forms is either
(a) smaller than or equal to (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater than or equal to (\code{operator = ">="})
the chosen \code{targetValue}. Note that the length of \code{itemValues} should
equal to the number of the length of \code{whichForms} times \code{whichItems}.
}
\examples{
## constraints to make sure that accross test form 1 and 3, only 4 items
##  of items 1:10 appear. Note that the constraint should be used in
##  in combination with constraining item overlap between the forms.
combineConstraints(
  acrossFormsConstraint(nForms = 3,
                        operator = "=", targetValue = 4,
                        whichForms = c(1, 3),
                        itemValues = c(rep(1, 10), rep(0, 10)),
                        itemIDs = 1:20),
  itemUsageConstraint(nForms = 3, nItems = 20, operator = "=", targetValue = 1,
                      itemIDs = 1:20)
                    )

## or alternatively
combineConstraints(
  acrossFormsConstraint(nForms = 3, nItems = 20,
                        operator = "=", targetValue = 4,
                        whichForms = c(1, 3),
                        whichItems = 1:10,
                        itemIDs = 1:20),
  itemUsageConstraint(nForms = 3, nItems = 20, operator = "=", targetValue = 1,
                      itemIDs = 1:20)
                    )

}
