% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemValuesMinMax.R
\name{itemValuesRange}
\alias{itemValuesRange}
\alias{itemValuesMin}
\alias{itemValuesMax}
\alias{itemValuesDeviation}
\title{Create single value constraints with minimum and maximum.}
\usage{
itemValuesRange(nForms, nItems, itemValues, range)

itemValuesMin(nForms, nItems, itemValues, min)

itemValuesMax(nForms, nItems, itemValues, max)

itemValuesDeviation(
  nForms,
  nItems,
  itemValues,
  targetValue,
  allowedDeviation,
  relative = FALSE
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{range}{a vector with two values, the the minimal and the maximum sum of
the \code{itemValues} per test form, respectively}

\item{min}{the minimal sum of the \code{itemValues} per test form}

\item{max}{the minimal sum of the \code{itemValues} per test form}

\item{targetValue}{the target test form value}

\item{allowedDeviation}{the maximum allowed deviation from the \code{targetValue}}

\item{relative}{a logical expressing whether or not the \code{allowedDeviation}
should be interpreted as a proportion of the \code{targetValue}}
}
\value{
A sparse matrix.
}
\description{
\code{itemValuesRange}, \code{itemValuesMin}, and \code{itemValuesMax}
create constraints related to an item parameter/value. That is, the created
constraints assure that the sum of the \code{itemValues} is smaller than or equal
to \code{max}, greater than or equal to \code{min}, or both \code{range}.
}
\details{
\code{itemValuesDeviation} also constrains the minimal and the maximal value
of the sum of the \code{itemValues}, but based on a chosen
and a maximal allowed deviation (i.e., \code{allowedDeviation}) from that \code{targetValue}.
}
\section{Functions}{
\itemize{
\item \code{itemValuesMin}: constrain minimum value

\item \code{itemValuesMax}: constrain maximum value

\item \code{itemValuesDeviation}: constrain the distance form the \code{targetValue}
}}

\examples{
## constraints to make sure that the sum of the item values (1:10) is between
## 4 and 6
itemValuesRange (2, 10, 1:10, range(min = 4, max = 6))

## or alternatively
itemValuesDeviation (2, 10, 1:10, targetValue = 5, allowedDeviation = 1)

}
