% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemExclusionTuples.R
\name{itemExclusionTuples}
\alias{itemExclusionTuples}
\title{Create item exclusion tuples.}
\usage{
itemExclusionTuples(items, idCol = "ID", exclusions, sepPattern = ", ")
}
\arguments{
\item{items}{A \code{data.frame} with information on an item pool.}

\item{idCol}{Name of the item ID column.}

\item{exclusions}{Name of the exclusion column.}

\item{sepPattern}{String which should be used for separating item IDs in the \code{exclusions} column..}
}
\value{
A \code{data.frame} with two columns.
}
\description{
If item exclusions are stored as a character vector, \code{itemExclusionTuples} separates this vector and creates item pairs ('tuples').
}
\details{
Exclusion tuples can be used by \code{\link{itemExclusionConstraint}} to set up exclusion constraints. Note that a
separator pattern has to be used consistently throughout the column (e.g. \code{", "}).
}
\examples{
# Example data.frame
items <- data.frame(ID = c("items1", "items2", "items3", "items4"),
                     exclusions = c("items2, items3", NA, NA, NA))

# Create tuples
itemExclusionTuples(items = items, idCol = "ID", exclusions = "exclusions",
                    sepPattern = ", ")


}
