% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoItemValuesMinMax.R
\name{autoItemValuesMinMax}
\alias{autoItemValuesMinMax}
\title{Create single value constraints with minimum and maximum.}
\usage{
autoItemValuesMinMax(
  nForms,
  itemValues,
  allowedDeviation = NULL,
  relative = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{allowedDeviation}{Numeric value of length 1. How much deviance is allowed from target values?}

\item{relative}{Is the \code{allowedDeviation} expressed as a proportion?}

\item{verbose}{Should calculated values be reported?}
}
\value{
A sparse matrix.
}
\description{
\code{\link{itemValuesDeviation}} creates constraints related to an item parameter/value. \code{autoItemValuesMixMax} automatically
determines the appropriate \code{targetValue} and then calls \code{\link{itemValuesDeviation}}. The function only works for
(dichotomous) dummy indicators with values 0 and 1.
}
\details{
Two scenarios are possible when automatically determining the target value: (a) Either items with the selected property could be exactly
distributed across test forms or (b) this is not possible. An example would be 2 test forms and 4 multiple choice items (a) or 2 test
forms and 5 multiple choice items (b). If (a), the tolerance level works exactly as one would expect. If (b) the tolerance level is
adapted, meaning that if tolerance level is 0 in example (b), allowed values are 2 or 3 multiple choice items per test form.
}
\examples{
autoItemValuesMinMax(2, itemValues = c(0, 1, 0, 1))

}
