% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EAT.R
\name{frontier.levels}
\alias{frontier.levels}
\title{Efficiency Analysis Trees Frontier Output Levels}
\usage{
frontier.levels(object)
}
\arguments{
\item{object}{An \code{EAT} object.}
}
\value{
\code{data.frame} with the frontier output levels at the leaf nodes.
}
\description{
This function returns the frontier output levels of an Efficiency Analysis Trees model.
}
\examples{

simulated <- Y1.sim(N = 50, nX = 3)
model <- EAT(data = simulated, x = c(1, 2, 3), y = 4, numStop = 10, fold = 5)
frontier.levels(model)

}
