% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.R
\name{manip_bin_numerics}
\alias{manip_bin_numerics}
\title{bin numerical columns}
\usage{
manip_bin_numerics(
  x,
  bins = 5,
  bin_labels = c("LL", "ML", "M", "MH", "HH"),
  center = T,
  scale = T,
  transform = T,
  round_numeric = T,
  digits = 2,
  NA_label = "NA"
)
}
\arguments{
\item{x}{dataframe with numeric variables, or numeric vector}

\item{bins}{number of bins for numerical variables, passed to cut as breaks
parameter, Default: 5}

\item{bin_labels}{labels for the bins from low to high, Default: c("LL",
"ML", "M", "MH", "HH"). Can also be one of c('mean', 'median', 'min_max',
'cuts'), the corresponding summary function will supply the labels.}

\item{center}{logical, Default: T}

\item{scale}{logical, Default: T}

\item{transform}{logical, apply Yeo Johnson Transformation, Default: T}

\item{round_numeric, }{logical, rounds numeric results if bin_labels is
supplied with a supported summary function name.}

\item{digits, }{integer, number of digits to round to}

\item{NA_label}{character vector, define label for missing data, Default:
'NA'}
}
\value{
dataframe
}
\description{
centers, scales and Yeo Johnson transforms numeric variables in
  a dataframe before binning into n bins of equal range. Outliers based on
  boxplot stats are capped (set to min or max of boxplot stats).
}
\examples{
summary( mtcars2 )
summary( manip_bin_numerics(mtcars2) )
summary( manip_bin_numerics(mtcars2, bin_labels = 'mean'))
summary( manip_bin_numerics(mtcars2, bin_labels = 'cuts'
  , scale = FALSE, center = FALSE, transform = FALSE))
}
