% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_generators.R
\name{runif_subrange}
\alias{runif_subrange}
\title{A subrange version of runif}
\usage{
runif_subrange(n, min, max)
}
\arguments{
\item{n}{Number of observations}

\item{min}{Lower limits of the distribution.}

\item{max}{Upper limits of the distribution.}
}
\value{
Generates values with runif, bounded by a range drawn from \code{sort(runif(2, min, max))}.
}
\description{
Will generate numbers from a random subrange within the given range.
For example, if [min, max]\verb{is set to \[0, 10\], this function could decide to generate}n` numbers between 2 and 6.
}
\examples{
runif_subrange(20, 0, 10)
}
