% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynfrail_arguments.R
\name{dynfrail_control}
\alias{dynfrail_control}
\title{Control parameters for dynfrail}
\usage{
dynfrail_control(nlm_control = list(stepmax = 1), inner_control = list(eps =
  1e-04, maxit = 100, verbose = FALSE, lik_tol = 1))
}
\arguments{
\item{nlm_control}{A list of named arguments to be sent to \code{nlm} for the outer optimization.}

\item{inner_control}{A list of parameters for the inner optimization. See details.}
}
\value{
An object of the type \code{dynfrail_control}.
}
\description{
Control parameters for dynfrail
}
\details{
The \code{nlm_control} argument should not overalp with \code{hessian}, \code{f} or \code{p}.

The \code{inner_control} argument should be a list with the following items:
\itemize{
\item{\code{eps}}{ A criterion for convergence of the EM algorithm (difference between two consecutive values of the log-likelihood)}
\item{\code{maxit}}{ The maximum number of iterations between the E step and the M step}
\item{\code{verbose}}{ Logical, whether details of the optimization should be printed}
\item{\code{lik_tol}}{ For values higher than this, the algorithm returns a warning when the log-likelihood decreases between EM steps. Technically, this should not happen, but
if the parameter \eqn{\theta} is somewhere really far from the maximum, numerical problems might lead in very small likelihood decreases.
}}

The starting value of the outer optimization may be set in the \code{dynfrail_dist()} argument.
}
\examples{
dynfrail_control()
# this stops each EM (inner maximization) after 10 iterations, event if it did not
# reach the maximum.
dynfrail_control(inner_control = list(maxit = 10))

}
\seealso{
\code{\link{dynfrail}}, \code{\link{dynfrail_dist}}
}
