% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.dynamitefit}
\alias{fitted.dynamitefit}
\title{Extract Fitted Values of a Dynamite Model}
\usage{
\method{fitted}{dynamitefit}(object, newdata = NULL, n_draws = NULL, expand = TRUE, df = TRUE, ...)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{newdata}{[\code{data.frame}]\cr Data used in predictions.
If \code{NULL} (default), the data used in model estimation is used for
predictions as well.
There should be no new time points that were not present in the data that
were used to fit the model, and no new group levels can be included.}

\item{n_draws}{[\code{integer(1)}]\cr Number of posterior samples to use,
default is \code{NULL} which uses all samples.}

\item{expand}{[\code{logical(1)}]\cr If \code{TRUE} (the default), the output
is a single \code{data.frame} containing the original \code{newdata} and the
predicted values. Otherwise, a \code{list} is returned with two components,
\code{simulated} and \code{observed}, where the first contains only the
predicted values, and the second contains the original \code{newdata}.
Setting \code{expand} to \code{FALSE} can help conserve memory because \code{newdata}
is not replicated \code{n_draws} times in the output.
This argument is ignored if \code{funs} are provided.}

\item{df}{[\code{logical(1)}]\cr If \code{TRUE} (default) the output
consists of \code{data.frame} objects, and \code{data.table} objects otherwise.}

\item{...}{Ignored.}
}
\value{
A \code{data.frame} containing the fitted values.
}
\description{
Fitted values for a \code{dynamitefit} object, i.e.,
\eqn{E(y_t | newdata, \theta)} where \eqn{\theta} contains all the
model parameters. See also
\code{\link[=predict.dynamitefit]{predict.dynamitefit()}} for multi-step predictions.
}
\examples{
fitted(gaussian_example_fit, n_draws = 2L)
\donttest{
set.seed(1)
fit <- dynamite(
  dformula = obs(LakeHuron ~ 1, "gaussian") + lags(),
  data = data.frame(LakeHuron, time = seq_len(length(LakeHuron)), id = 1),
  time = "time",
  group = "id",
  chains = 1,
  refresh = 0
)

if (requireNamespace("dplyr") &&
  requireNamespace("tidyr") &&
  base::getRversion() >= "4.1.0") {

  # One-step ahead samples (fitted values) from the posterior
  # (first time point is fixed due to lag in the model):
  fitted(fit) |>
    dplyr::filter(time > 2) |>
    ggplot2::ggplot(ggplot2::aes(time, LakeHuron_fitted, group = .draw)) +
    ggplot2::geom_line(alpha = 0.5) +
    # observed values
    ggplot2::geom_line(ggplot2::aes(y = LakeHuron), colour = "tomato") +
    ggplot2::theme_bw()

  # Posterior predictive distribution given the first time point:
  predict(fit, type = "mean") |>
    dplyr::filter(time > 2) |>
    ggplot2::ggplot(ggplot2::aes(time, LakeHuron_mean, group = .draw)) +
    ggplot2::geom_line(alpha = 0.5) +
    # observed values
    ggplot2::geom_line(ggplot2::aes(y = LakeHuron), colour = "tomato") +
    ggplot2::theme_bw()
}
}

}
\seealso{
Obtaining predictions
\code{\link{predict.dynamitefit}()}
}
\concept{prediction}
