% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.dynamitefit}
\alias{coef.dynamitefit}
\title{Extract Regression Coefficients of a Dynamite Model}
\usage{
\method{coef}{dynamitefit}(
  object,
  type = c("beta", "delta", "nu", "lambda", "psi"),
  responses = NULL,
  summary = TRUE,
  probs = c(0.05, 0.95),
  include_alpha = TRUE,
  ...
)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{type}{[\code{character(1)}]\cr Either \code{beta} (the default) for
time-invariant coefficients, \code{delta} for time-varying coefficients,
\code{nu} for random intercepts, \code{lambda} for factor loadings, or \code{psi} for
latent factor.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE} (default), returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE}, returns the posterior
samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{include_alpha}{[\code{logical(1)}]\cr If \code{TRUE} (default), extracts also
time-invariant intercept term alpha if time-invariant parameters beta are
extracted, and time-varying alpha if time-varying delta are extracted.}

\item{...}{Ignored.}
}
\value{
A \code{tibble} containing either samples or summary statistics of the
model parameters in a long format.
}
\description{
Extracts either time-varying or time-invariant parameters of the model.
}
\examples{
betas <- coef(gaussian_example_fit, type = "beta")
deltas <- coef(gaussian_example_fit, type = "delta")

}
