% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_design_matrix.R
\name{ddFixed}
\alias{ddFixed}
\alias{ddFixed_intercept}
\title{Auxiliary functions for fixed effects}
\usage{
ddFixed(object)

ddFixed_intercept(n)
}
\arguments{
\item{object}{Expression that would be used in formula. E.g. \code{x} or \code{poly(x, degree = 3)}}

\item{n}{Number of rows in the data frame the data for estimation}
}
\description{
Functions used in formula of \code{\link{ddhazard}} for time-invariant effects. \code{ddFixed_intercept} is only used for the intercept.
}
\examples{
# All these call with give the same result where
# 'data' is a hypothetical data frame. We can get a
# time-invariant estimate for x1 by:
\dontrun{
ddhazard(Surv(stop, event) ~ ddFixed(x1), data)
}

# All of the calls below will yield the same result
# with a time-invariant intercept:
\dontrun{
ddhazard(Surv(stop, event)
    ~ ddFixed(1) + x1, data)
ddhazard(Surv(stop, event)
    ~ -1 + ddFixed(1) + x1, data)
ddhazard(Surv(stop, event)
    ~ ddFixed(rep(1, nrow(data))) + x1, data)
ddhazard(Surv(stop, event)
    ~ -1 + ddFixed(rep(1, nrow(data))) + x1, data)
ddhazard(Surv(stop, event)
    ~ ddFixed_intercept(nrow(data)) + x1, data)
ddhazard(Surv(stop, event)
    ~ -1 + ddFixed_intercept(nrow(data)) + x1, data)
}
}
