% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Objective-func.R
\name{objective_fun}
\alias{objective_fun}
\title{Calculate measures of goodness of fit for DYCD model simulations.}
\usage{
objective_fun(
  sim,
  obs,
  fun = c("NSE", "RMSE"),
  start.date,
  end.date,
  min.depth,
  max.depth,
  by.value
)
}
\arguments{
\item{sim}{a matrix of bio-geochemical variable values with column of time and row of depth.}

\item{obs}{a data frame of observed value, with three columns: Date, depth, value.}

\item{fun}{objective function to be calculated. select any from 'NSE', 'RMSE', 'MAE', 'RAE', and 'Pearson'. Multiple is allowed.}

\item{start.date, end.date}{the beginning and ending simulation dates for the intended DYRESM-CAEDYM model run. The date format must be "\%Y-\%m-\%d".}

\item{min.depth, max.depth}{the minimum and maximum depths of the simulation matrix .}

\item{by.value}{the value of increment for depth of the simulation matrix.}
}
\value{
a vector of objective function values. The first is NSE and the second is RMSE.
}
\description{
calculate any of the five objective functions that are commonly used to measure goodness of fit:
   1) Nash-Sutcliffe efficiency coefficient (NSE),
   2) Root Mean Square Error (RMSE),
   3) Mean Absolute Error (MAE),
   4) Relative Absolute Error (RAE), and
   5) Pearson's r (Pearson).
}
