% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dct_terms}
\alias{dct_terms}
\title{Darwin Core Taxon terms}
\format{
Dataframe (tibble), including two columns:
\itemize{
\item \code{group}: Darwin Core term group; either "taxon" (terms in the Taxon class)
or "record-level" (terms that are generic in that they might apply
to any type of record in a dataset.)
\item \code{term}: Darwin Core term
}

with two additional attributes:
\itemize{
\item \code{retrieved}: Date the terms were obtained
\item \code{url}: URL from which the terms were obtained
}
}
\source{
\url{https://dwc.tdwg.org/terms/#taxon}
}
\usage{
dct_terms
}
\description{
A table of valid Darwin Core terms. Only terms in the Taxon class or at the
record-level are included.
}
\details{
Modified from data downloaded from \href{https://dwc.tdwg.org/}{TDWG Darwin Core}
under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution (CC BY) 4.0}
license.
}
\examples{
dct_terms
}
\keyword{datasets}
