% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{combine_rules}
\alias{combine_rules}
\title{Combine Two Rules}
\usage{
combine_rules(x, y, ...)
}
\arguments{
\item{x}{(\code{rule}) to modify.}

\item{y}{(\code{rule}) rule whose mapping will take precedence over the ones described in \code{x}.}

\item{...}{not used.}
}
\value{
a \code{rule}.
}
\description{
Combine Two Rules
}
\note{
The order of the mappings in the resulting rule corresponds to the order of the mappings in \code{x} followed by the
mappings that are only present in \code{y}.
}
\examples{
r1 <- rule(
  "first" = c("from ori rule", "FROM ORI RULE"),
  "last" = c(NA, "last"),
  .to_NA = "X",
  .drop = TRUE
)
r2 <- rule(
  "first" = c("F", "f"),
  "second" = c("S", "s"),
  "third" = c("T", "t"),
  .to_NA = "something"
)
combine_rules(r1, r2)
}
