% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.twdtw_knn1}
\alias{plot.twdtw_knn1}
\title{Plot Patterns from twdtw-knn1 model}
\usage{
\method{plot}{twdtw_knn1}(x, bands = NULL, ...)
}
\arguments{
\item{x}{A model of class \code{"twdtw_knn1"}.}

\item{bands}{A character vector specifying the bands or indices to plot.
If NULL (default), all available bands or indices in the data will be plotted.}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{ggplot}}. Currently not used.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object displaying the time series patterns.
}
\description{
This function visualizes time series patterns from the \code{"twdtw_knn1"} model.
It produces a multi-faceted plot, where each facet represents a different time series
label from the model's data. Within each facet, different bands or indices (attributes)
are plotted as distinct lines, differentiated by color.
}
\examples{
\dontrun{

# Read training samples
samples_path <- 
  system.file("mato_grosso_brazil/samples.gpkg", package = "dtwSat")

samples <- st_read(samples_path, quiet = TRUE)

# Get satellite image time sereis files
tif_path <- system.file("mato_grosso_brazil", package = "dtwSat")
tif_files <- dir(tif_path, pattern = "\\\\.tif$", full.names = TRUE)

# Get acquisition dates
acquisition_date <- regmatches(tif_files, regexpr("[0-9]{8}", tif_files))
acquisition_date <- as.Date(acquisition_date, format = "\%Y\%m\%d")

# Create a 3D datacube
dc <- read_stars(tif_files,
                 proxy = FALSE,
                 along = list(time = acquisition_date),
                 RasterIO = list(bands = 1:6))
dc <- st_set_dimensions(dc, 3, c("EVI", "NDVI", "RED", "BLUE", "NIR", "MIR"))
dc <- split(dc, c("band"))

# Create a knn1-twdtw model
m <- twdtw_knn1(x = dc,
                y = samples,
                cycle_length = 'year',
                time_scale = 'day',
                time_weight = c(steepness = 0.1, midpoint = 50),
                formula = band ~ s(time))

print(m)

# Visualize model patterns
plot(m)

# Classify satellite images
system.time(lu <- predict(dc, model = m))

# Visualise land use classification
ggplot() +
  geom_stars(data = lu) +
  theme_minimal()

}
}
\seealso{
twdtw_knn1
}
