% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPatterns.R
\docType{methods}
\name{createPatterns}
\alias{createPatterns}
\alias{createPatterns,twdtwTimeSeries-method}
\alias{createPatterns-twdtwMatches}
\title{Create patterns}
\usage{
createPatterns(x, from = NULL, to = NULL, freq = 1, attr = NULL,
  split = TRUE, formula, ...)

\S4method{createPatterns}{twdtwTimeSeries}(x, from = NULL, to = NULL,
  freq = 1, attr = NULL, split = TRUE, formula, ...)
}
\arguments{
\item{x}{an object of class \code{\link[dtwSat]{twdtwTimeSeries}}.}

\item{from}{A character or \code{\link[base]{Dates}} object in the format 
"yyyy-mm-dd". If not provided it is equal to the smallest date of the 
first element in x. See details.}

\item{to}{A \code{\link[base]{character}} or \code{\link[base]{Dates}} 
object in the format "yyyy-mm-dd". If not provided it is equal to the 
greatest date of the first element in x. See details.}

\item{freq}{An integer. The sampling frequency of the output patterns.}

\item{attr}{A vector character or numeric. The attributes in \code{x} to be used. 
If not declared the function uses all attributes.}

\item{split}{A logical. If TRUE the samples are split by label. If FALSE 
all samples are set to the same label.}

\item{formula}{A formula. Argument to pass to \code{\link[mgcv]{gam}}.}

\item{...}{other arguments to pass to the function \code{\link[mgcv]{gam}} in the 
package \pkg{mgcv}.}
}
\value{
an object of class \code{\link[dtwSat]{twdtwTimeSeries}}
}
\description{
Create temporal patterns from objects of class twdtwTimeSeries.
}
\details{
The hidden assumption is that the temporal pattern is a cycle the repeats itself 
within a given time interval. Therefore, all time series samples in \code{x} are aligned 
with each other, keeping their respective sequence of days of the year. The function fits a 
Generalized Additive Model (GAM) to the aligned set of samples.
}
\examples{
# Creating patterns from objects of class twdtwTimeSeries 
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, timeline=timeline)

# Read field samples 
\dontrun{
field_samples = read.csv(system.file("lucc_MT/data/samples.csv", package="dtwSat"))
prj_string = scan(system.file("lucc_MT/data/samples_projection", package="dtwSat"), 
                  what = "character")

# Extract time series 
ts = getTimeSeries(rts, y = field_samples, proj4string = prj_string)

# Create temporal patterns 
patt = createPatterns(x=ts, from="2005-09-01", to="2006-09-01", freq=8, formula = y~s(x))

# Plot patterns 
autoplot(patt[[1]], facets = NULL) + xlab("Time") + ylab("Value")

}
}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwTimeSeries-class}}, 
\code{\link[dtwSat]{getTimeSeries}}, and 
\code{\link[dtwSat]{twdtwApply}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
