% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minute-decimal.R
\name{dtt_minute_decimal}
\alias{dtt_minute_decimal}
\alias{dtt_minute_decimal.Date}
\alias{dtt_minute_decimal.POSIXct}
\alias{dtt_minute_decimal.hms}
\title{Get Decimal Minute Values}
\usage{
dtt_minute_decimal(x, ...)

\method{dtt_minute_decimal}{Date}(x, ...)

\method{dtt_minute_decimal}{POSIXct}(x, ...)

\method{dtt_minute_decimal}{hms}(x, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}
}
\value{
A numeric vector.
}
\description{
Gets decimal minute values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get numeric vector of decimal minute values for a Date vector

\item \code{POSIXct}: Get numeric vector of decimal minute values for a POSIXct vector

\item \code{hms}: Get numeric vector of decimal minute values for a hms vector
}}

\examples{
x <- as.POSIXct("1990-01-02 23:40:51")
dtt_minute_decimal(x)
x <- hms::as_hms("23:40:51")
dtt_minute_decimal(x)
}
\seealso{
\code{\link[=dtt_minute]{dtt_minute()}}

Other decimal: 
\code{\link{dtt_day_decimal}()},
\code{\link{dtt_doy_decimal}()},
\code{\link{dtt_hour_decimal}()},
\code{\link{dtt_month_decimal}()},
\code{\link{dtt_year_decimal}()}
}
\concept{decimal}
