% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/second.R, R/set.R
\name{dtt_seconds}
\alias{dtt_seconds}
\alias{dtt_seconds<-}
\alias{dtt_second}
\alias{dtt_second<-}
\alias{dtt_second.Date}
\alias{dtt_second.POSIXct}
\alias{dtt_second.hms}
\alias{dtt_second<-.POSIXct}
\alias{dtt_second<-.hms}
\alias{dtt_set_second}
\title{Get and Set Second Values}
\usage{
dtt_seconds(x, ...)

dtt_seconds(x) <- value

dtt_second(x, ...)

dtt_second(x) <- value

\method{dtt_second}{Date}(x, ...)

\method{dtt_second}{POSIXct}(x, ...)

\method{dtt_second}{hms}(x, ...)

\method{dtt_second}{POSIXct}(x) <- value

\method{dtt_second}{hms}(x) <- value

dtt_set_second(x, value)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}

\item{value}{A integer vector of the second value(s).}
}
\value{
An integer vector (or the modified date/time vector).
}
\description{
Gets and sets second values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get integer vector of second values for a Date vector

\item \code{POSIXct}: Get integer vector of second values for a POSIXct vector

\item \code{hms}: Get integer vector of second values for a time vector

\item \code{POSIXct}: Set second values for a POSIXct vector

\item \code{hms}: Set second values for a hms vector
}}

\examples{
x <- as.POSIXct("1990-01-02 23:40:51")
dtt_second(x)
dtt_second(x) <- 27L
x

x <- hms::as.hms("23:40:51")
dtt_second(x)
dtt_second(x) <- 27L
x
}
