% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{dtt_date}
\alias{dtt_date}
\alias{dtt_date.integer}
\alias{dtt_date.double}
\alias{dtt_date.character}
\alias{dtt_date.Date}
\alias{dtt_date.POSIXct}
\alias{dtt_date.hms}
\title{Date}
\usage{
dtt_date(x, ...)

\method{dtt_date}{integer}(x, ...)

\method{dtt_date}{double}(x, ...)

\method{dtt_date}{character}(x, ...)

\method{dtt_date}{Date}(x, ...)

\method{dtt_date}{POSIXct}(x, ...)

\method{dtt_date}{hms}(x, ...)
}
\arguments{
\item{x}{A vector.}

\item{...}{Unused.}
}
\value{
A floored Date vector.
}
\description{
Coerces vectors to floored Date vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{integer}: Coerce integer vector to a floored Date vector

\item \code{double}: Coerce double vector to a floored Date vector

\item \code{character}: Coerce character vector to a floored Date vector

\item \code{Date}: Coerce Date vector to a floored Date vector

\item \code{POSIXct}: Coerce POSIXct vector to a floored Date vector

\item \code{hms}: Coerce hms vector to a floored Date vector
}}

\examples{
dtt_date(1L)
dtt_date(-1)
dtt_date("2000-01-01")
as.Date(as.POSIXct("2019-05-01", tz = "Etc/GMT-8"))
dtt_date(as.POSIXct("2019-05-01", tz = "Etc/GMT-8"))
dtt_date(hms::as.hms("23:59:59"))
dtt_date(hms::as.hms("24:00:00"))
}
