% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-resampling-uncertainty.R
\name{rue_pt}
\alias{rue_pt}
\title{Dataset Shift via Resampling (Prediction) Uncertainty}
\usage{
rue_pt(
  x_train,
  x_test,
  R = 1000,
  sub_ratio = 1/2,
  num_trees = 500L,
  response_name = "label"
)
}
\arguments{
\item{x_train}{Training sample.}

\item{x_test}{Test sample.}

\item{R}{The number of permutations. May be ignored.}

\item{sub_ratio}{Subsampling ratio for sample splitting. May be ignored.}

\item{num_trees}{The number of trees in random forests.}

\item{response_name}{The column name of the categorical outcome to predict.}
}
\value{
A named list or object of class \code{outlier.test} containing:
\itemize{
   \item \code{statistic}: observed WAUC statistic
   \item \code{seq_mct}: sequential Monte Carlo test, if applicable
   \item \code{p_value}: p-value
   \item \code{outlier_scores}: outlier scores from training and test set
}
}
\description{
Test for no adverse shift via prediction uncertainty for two-sample comparison.
The scores are out-of-bag predictions from random forests with the package
\pkg{ranger}. The prefix \emph{rue} stands for resampling uncertainty, the
relevant notion of outlier. This uncertainty is the standard error of the
mean predictions. This assumes that both training and test sets are labeled.
}
\details{
The empirical null distribution uses \code{R} permutations to estimate
the p-value. For speed, this is implemented as a sequential Monte Carlo test
with the \pkg{simctest} package. See Gandy (2009) for details. The suffix
\emph{pt} refers to permutation test. It does not use the asymptotic
(theoretical) null distribution for the weighted AUC (WAUC), the test
statistic. This is the recommended approach for small samples.
}
\section{Notes}{

For resampling uncertainty, we essentially implement the approach in
Schulam & Saria (2019) with random forests. The standard errors of the mean
predictions are the underlying scores. Any performant method for 
confidence-based out-of-distribution detection can replace random forests,
the default in this implementation.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
idx <- sample(nrow(iris), 2 / 3 * nrow(iris))
xy_train <- iris[idx, ]
xy_test <- iris[-idx, ]
iris_test <- rue_pt(xy_train, xy_test, response_name = "Species")
str(iris_test)
}
}
\references{
Kamulete, V. M. (2021).
\emph{Test for non-negligible adverse shifts}.
arXiv preprint arXiv:2107.02990.

Schulam, P., & Saria, S. (2019, April).
Can you trust this prediction? Auditing pointwise reliability after learning.
In The 22nd International Conference on Artificial Intelligence and Statistics (pp. 1022-1031). PMLR.

Berger, C., Paschali, M., Glocker, B., & Kamnitsas, K. (2021). 
Confidence-based Out-of-Distribution Detection: A Comparative Study and Analysis. 
arXiv preprint arXiv:2107.02568.

Gandy, A. (2009).
\emph{Sequential implementation of Monte Carlo tests with uniformly bounded resampling risk}.
Journal of the American Statistical Association, 104(488), 1504-1511.

Li, J., & Fine, J. P. (2010).
\emph{Weighted area under the receiver operating characteristic curve and its application to gene selection}.
Journal of the Royal Statistical Society: Series C (Applied Statistics), 59(4), 673-692.
}
\concept{uncertainty}
