\name{curvature}
\alias{curvature}
\alias{curvature.default}
\alias{curvature.Darray}

\title{Curvature}
\description{Curvature calculations and summary statistics as in Bates and Watts.
}
\usage{
    curvature(obj, ...)
    \method{curvature}{default}(obj, x, obj.args=NULL, d=0.01, eps=1e-4,r=6,
        signif=0.05, show.details=F, warn=T)
    \method{curvature}{Darray}(obj, signif = 0.05,
        show.extra.details=F, show.details=show.extra.details, warn=T)
}
\arguments{
    \item{obj}{An object of class Dlist, TSestModel,
      or a function for the default method.}
    \item{x}{parameters to the function.}
    \item{signif}{The significance level to }
    \item{show.details}{If show.details=T then intermediate calculations are printed.}
    \item{track}{If track=T then the progress of the calculations is printed.}
}
\details{
The function is generic. It can be called with a function and parameter matrix,
 in which case the Bates and Watts D matrix is calculated, or with a previously
 calculated D matrix. A function should return a sample space vector at the 
    parameter value x.
    Dlist is a list as generated by genD,
       with the 3 elements as follows:
   D is a matrix of first(gradients) and second order partial
      derivatives organized in the same manner as Bates and 
      Watts. (first p columns are the gradients and the 
      next p(p-1)/2 columns are the lower triangle of the Hessian).
   p is the dimension of the parameter space=dim of the tangent space.
   f0 is the function value at the point where the matrix D 
        was calculated. (The calculation should not/does not? depend on
        this value - but it should be the right dimension and 0's do
        not work.
}
\value{
A list is returned (with invisible). Curvature summary statistics as in Bates 
and Watts are in the element stat. A representation of the Bates and 
Watts D matrix is in the element Dlist. The curvature array C as in
Batts and Watts defn. (7.16) p242 and examples p244 &  p245 is in the 
elements C.parameter and C.intrinsic.
}
\sideffects{Curvature summary statistics as in Bates and Watts are printed.}
\references{ 
Bates and Watts(1983), 'Nonlinear Regression Analysis and Its Applications.'
}
\seealso{
\code{\link{genD}}
}
\examples{
    func <- function(x){c(x[1], x[1], x[2]^2)}
 #   curvature(func, c(2,2))
}
%\keyword{DSE}
\keyword{ts}

