% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_util_fun.R
\name{days_in_month}
\alias{days_in_month}
\title{How many days are in a month (of given date)?}
\usage{
days_in_month(dt = Sys.Date(), ...)
}
\arguments{
\item{dt}{Date or time (scalar or vector). 
Default: \code{dt = Sys.Date()}. 
Numbers or strings with dates are parsed into 
4-digit numbers denoting the year.}

\item{...}{Other parameters (passed to \code{as.Date()}).}
}
\value{
A named (numeric) vector.
}
\description{
\code{days_in_month} computes the number of days in the months of 
given dates (provided as a date or time \code{dt}, 
or number/string denoting a 4-digit year).
}
\details{
The function requires \code{dt} as "Dates", 
rather than month names or numbers, 
to check for leap years (in which February has 29 days).
}
\examples{
days_in_month() 

# Robustness: 
days_in_month(Sys.Date())    # Date
days_in_month(Sys.time())    # POSIXct
days_in_month("2020-07-01")  # string
days_in_month(20200901)      # number
days_in_month(c("2020-02-10 01:02:03", "2021-02-11", "2024-02-12"))  # vectors of strings

# For leap years:
ds <- as.Date("2020-02-20") + (365 * 0:4)  
days_in_month(ds)  # (2020/2024 are leap years)

}
\seealso{
\code{\link{is_leap_year}} to check for leap years; 
\code{\link{diff_tz}} for time zone-based time differences; 
\code{days_in_month} function of the \strong{lubridate} package.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
