% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exec-session.R
\name{drake_get_session_info}
\alias{drake_get_session_info}
\title{Return the \code{\link[=sessionInfo]{sessionInfo()}}
of the last call to \code{\link[=make]{make()}}.}
\usage{
drake_get_session_info(path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose =
  verbose), verbose = 1L)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}
}
\value{
\code{\link[=sessionInfo]{sessionInfo()}} of the last
call to \code{\link[=make]{make()}}
}
\description{
By default, session info is saved
during \code{\link[=make]{make()}} to ensure reproducibility.
Your loaded packages and their versions are recorded, for example.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
drake_get_session_info() # Get the cached sessionInfo() of the last make().
}
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}}, \code{\link[=cached]{cached()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
