% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staged_parallelism.R
\name{next_stage}
\alias{next_stage}
\title{List the targets that will be built in the
first parallelizable stage of the next call to \code{\link[=make]{make()}}.}
\usage{
next_stage(config = drake::read_drake_config())
}
\arguments{
\item{config}{A master configuration list produced by
\code{\link[=drake_config]{drake_config()}} or \code{\link[=make]{make()}}}
}
\value{
A character vector of the targets to be made
in the first parallel stage of the next call to \code{\link[=make]{make()}}.
}
\description{
Similar to the first stage in the output of
\code{\link[=parallel_stages]{parallel_stages()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
config <- load_basic_example() # Get the code with drake_example("basic").
next_stage(config = config)    # "small" and "large"
})
}
}
\seealso{
\code{\link[=parallel_stages]{parallel_stages()}},
\code{\link[=make]{make()}}, \code{\link[=drake_config]{drake_config()}}
}
