% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_runtime.R
\name{predict_runtime}
\alias{predict_runtime}
\title{Function predict_runtime}
\usage{
predict_runtime(plan = workplan(), from_scratch = FALSE,
  targets_only = FALSE, targets = drake::possible_targets(plan),
  envir = parent.frame(), verbose = TRUE, hook = function(code) {    
  force(code) }, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), parallelism = drake::default_parallelism(), jobs = 1,
  future_jobs = jobs, packages = rev(.packages()), prework = character(0),
  config = NULL, digits = 3, path = getwd(), search = TRUE)
}
\arguments{
\item{plan}{same as for \code{\link{make}}}

\item{from_scratch}{logical, whether to predict a
\code{\link{make}()} build from scratch or to
take into account the fact that some targets may be
already up to date and therefore skipped.}

\item{targets_only}{logical, whether to factor in
just the targets into the calculations or use the
build times for everything, including the imports}

\item{targets}{Targets to build in the workplan.
Timing information is
limited to these targets and their dependencies.}

\item{envir}{same as for \code{\link{make}}}

\item{verbose}{same as for \code{\link{make}}}

\item{hook}{same as for \code{\link{make}}}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
The \code{cache} argument is ignored if a
non-null \code{config} argument is supplied.}

\item{parallelism}{same as for \code{\link{make}}. Used
to parallelize import objects.}

\item{jobs}{same as for \code{\link{make}}, just used to
process imports}

\item{future_jobs}{hypothetical number of jobs
assumed for the predicted runtime.
assuming this number of jobs.}

\item{packages}{same as for \code{\link{make}}}

\item{prework}{same as for \code{\link{make}}}

\item{config}{option internal runtime parameter list of
\code{\link{make}(...)},
produced with \code{\link{config}()}.
Overrides all arguments except \code{from_scratch},
\code{targets_only}, and \code{digits}.
Computing \code{config}
in advance could save time if you plan multiple calls to
this function.}

\item{digits}{number of digits for rounding the times.}

\item{path}{file path to the folder containing the cache.
Yes, this is the parent directory containing the cache,
not the cache itself.}

\item{search}{logical, whether to search back in the file system
for the cache.}
}
\description{
Predict the elapsed runtime of the next call to `make()`.
This function simply sums the elapsed build times.
from \code{\link{rate_limiting_times}()}.
}
\details{
For the results to make sense, the previous build times
of all targets need to be available (automatically cached
by \code{\link{make}()}). Otherwise, \code{predict_runtime()}
will warn you and tell you which targets have missing times.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
predict_runtime(my_plan, digits = 4) # everything is up to date
predict_runtime(my_plan, digits = 4, from_scratch = TRUE) # 1 job
predict_runtime(my_plan, future_jobs = 2, digits = 4, from_scratch = TRUE)
predict_runtime(
  my_plan,
  targets = c("small", "large"),
  future_jobs = 2,
  digits = 4,
  from_scratch = TRUE
)
}
}
\seealso{
\code{\link{rate_limiting_times}},
\code{\link{build_times}}
\code{\link{make}}
}
