context("check")

test_that("check() works correctly", {
  clean(destroy=TRUE)
  x = example_plan("small")
  y = data.frame(code = character(0), output = character(0))
  expect_error(check(y))
  expect_error(check(data.frame(code = "1", bla = "a")))
  expect_error(check(data.frame(nobody = "1", output = "a")))
  expect_silent(check(data.frame(code = "1", output = "a")))
  expect_error(check(x, output = NULL))
  expect_error(check(x, output = "bla"))
  expect_error(check(x, envir = "bla"))
  clean(destroy=TRUE)
  expect_true(!file.exists(cache_path))
  expect_silent(check(x))
  unlink("input")
  x = example_plan("debug")
  expect_error(check(x))
  clean(destroy=TRUE)
  x = data.frame(output = c("z", "z"), code = c("1", "1"),
    stringsAsFactors = F)
  expect_error(check(x))
  x$output[2] = "'z'"
  expect_silent(check(x))
  x = plan(list = c(out = "readRDS('input')"))
  expect_error(check(x))
  file.create("input")
  expect_silent(check(x))
  unlink("input")
  clean(destroy=TRUE)
  expect_true(!file.exists(cache_path))
  expect_true(!file.exists("input"))
  clean(destroy=TRUE)
})

test_that("check() fails correctly when there's a cycle", {
  clean(destroy=TRUE)
  p = plan(a = b, b = a)
  expect_error(check(p))
  p = plan(a = b, b = c, c = a)
  expect_error(check(p))
  unlink(cache_path, recursive = T)
  expect_false(file.exists(cache_path))
  clean(destroy=TRUE)
  p = plan(k = f(1))
  f = function(x) g(x)
  g = function(x) f(x)
  expect_error(check(p))
  clean(destroy=TRUE)
})

test_that("self$deps(bad_value) correctly fails", {
  clean(destroy=TRUE)
  p = example_plan()
  x = Make$new(plan = p, verbose = F, envir = environment())
  expect_error(x$deps("blablabla"))
  clean(destroy=TRUE)
})

test_that("check() outputs message when quoted strings found.", {
  clean(destroy=TRUE)
  expect_silent(check(example_plan("small")))
  debug_setup()
  expect_output(check(example_plan("debug")))
  debug_cleanup()
})
