% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datapackage_init.R
\name{datapackage_init}
\alias{datapackage_init}
\title{Initialise a data package from a data frame, metadata list, and source code
file used to create the data set.}
\usage{
datapackage_init(df, package_name = NULL, meta = NULL,
  source_cleaner = NULL, source_cleaner_rename = TRUE, ...)
}
\arguments{
\item{df}{The object name of the data frame you would like to convert into a
data package.}

\item{package_name}{character string name for the data package. Unnecessary
if the \code{name} field is specified in \code{meta}.}

\item{meta}{The list object with the data frame's meta data. The list
item names must conform to the Open Knowledge Foundation's Data Package
Protocol (see \url{http://dataprotocols.org/data-packages/}). Must include
the \code{name}, \code{license}, and \code{version} fields.
If \code{resources} is not specified then this will be automatically
generated.\code{dpmr} uses \code{jsonlite} to convert the list into a
JSON file. See the \code{\link{toJSON}} documentation for details.
If \code{meta = NULL} then a barebones \code{datapackage.json} file will be
created.}

\item{source_cleaner}{a character string or vector of file paths relative to
the current working directory pointing to the source code file used to gather
and clean the \code{df} data frame. Can be in R or any other language, e.g.
Python. Following Data Package convention the scripts are renamed
\code{process*.*}, unless specified otherwise with
\code{source_cleaner_rename}. \code{source_cleaner} is not required, but
HIGHLY RECOMMENDED.}

\item{source_cleaner_rename}{logical. Whether or not to rename the
\code{source_cleaner} files.}

\item{...}{arguments to pass to \code{\link{export}}.}
}
\description{
Initialise a data package from a data frame, metadata list, and source code
file used to create the data set.
}
\examples{
\dontrun{
# Create fake data
A <- B <- C <- sample(1:20, size = 20, replace = TRUE)
ID <- sort(rep('a', 20))
Data <- data.frame(ID, A, B, C)

# Initialise data package with barebones, automatically generated metadata
datapackage_init(df = Data, package_name = 'My_Data_Package')

# Initialise with user specified metadata
meta_list <- list(name = 'My_Data_Package',
                 title = 'A fake data package',
                 last_updated = Sys.Date(),
                 version = '0.1',
                 license = data.frame(type = 'PDDL-1.0',
                          url = 'http://opendatacommons.org/licenses/pddl/'),
                 sources = data.frame(name = 'Fake',
                          web = 'No URL, its fake.'))

 datapackage_init(df = Data, meta = meta_list)
}
}

