% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.R
\name{ntile}
\alias{ntile}
\title{Bucket a numeric vector into \code{n} groups}
\usage{
ntile(x = row_number(), n)
}
\arguments{
\item{x}{A vector to rank

By default, the smallest values will get the smallest ranks. Use \code{\link[=desc]{desc()}}
to reverse the direction so the largest values get the smallest ranks.

Missing values will be given rank \code{NA}. Use \code{coalesce(x, Inf)} or
\code{coalesce(x, -Inf)} if you want to treat them as the largest or smallest
values respectively.

To rank by multiple columns at once, supply a data frame.}

\item{n}{Number of groups to bucket into}
}
\description{
\code{ntile()} is a sort of very rough rank, which breaks the input vector into
\code{n} buckets. If \code{length(x)} is not an integer multiple of \code{n}, the size of
the buckets will differ by up to one, with larger buckets coming first.

Unlike other ranking functions, \code{ntile()} ignores ties: it will create
evenly sized buckets even if the same value of \code{x} ends up in different
buckets.
}
\examples{
x <- c(5, 1, 3, 2, 2, NA)
ntile(x, 2)
ntile(x, 4)

# If the bucket sizes are uneven, the larger buckets come first
ntile(1:8, 3)

# Ties are ignored
ntile(rep(1, 8), 3)
}
\seealso{
Other ranking functions: 
\code{\link{percent_rank}()},
\code{\link{row_number}()}
}
\concept{ranking functions}
